/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class InMemoryTokenCache {
    private final Map<String, Integer> nameToId = new CopyOnWriteHashMap<String, Integer>();
    private final Map<Integer, NamedToken> idToToken = new CopyOnWriteHashMap<Integer, NamedToken>();
    private final String tokenType;

    public InMemoryTokenCache(String tokenType) {
        this.tokenType = tokenType;
    }

    public void clear() {
        this.nameToId.clear();
        this.idToToken.clear();
    }

    private void putAndEnsureUnique(Map<String, Integer> nameToId, NamedToken token, String tokenType) {
        Integer previous = nameToId.putIfAbsent(token.name(), token.id());
        if (previous != null && previous.intValue() != token.id()) {
            this.idToToken.remove(token.id(), token);
            throw new NonUniqueTokenException(tokenType, token.name(), token.id(), previous);
        }
    }

    public void putAll(List<NamedToken> tokens) throws NonUniqueTokenException {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap<Integer, NamedToken> newIdToToken = new HashMap<Integer, NamedToken>();
        for (NamedToken token : tokens) {
            newIdToToken.put(token.id(), token);
            this.putAndEnsureUnique(newNameToId, token, this.tokenType);
        }
        this.idToToken.putAll(newIdToToken);
        this.nameToId.putAll(newNameToId);
    }

    public void put(NamedToken token) throws NonUniqueTokenException {
        this.idToToken.put(token.id(), token);
        this.putAndEnsureUnique(this.nameToId, token, this.tokenType);
    }

    public Integer getId(String name) {
        return this.nameToId.get(name);
    }

    public NamedToken getToken(int id) {
        return this.idToToken.get(id);
    }

    public Iterable<NamedToken> allTokens() {
        return this.idToToken.values();
    }

    public int size() {
        return this.nameToId.size();
    }
}

