/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public interface StorageReader
extends AutoCloseable {
    public void acquire();

    public void release();

    @Override
    public void close();

    public Cursor<NodeItem> acquireSingleNodeCursor(long var1);

    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long var1);

    public Cursor<RelationshipItem> acquireNodeRelationshipCursor(boolean var1, long var2, long var4, Direction var6, IntPredicate var7);

    public Cursor<RelationshipItem> relationshipsGetAllCursor();

    public Cursor<PropertyItem> acquirePropertyCursor(long var1, Lock var3, AssertOpen var4);

    public Cursor<PropertyItem> acquireSinglePropertyCursor(long var1, int var3, Lock var4, AssertOpen var5);

    public LabelScanReader getLabelScanReader();

    public IndexReader getIndexReader(SchemaIndexDescriptor var1) throws IndexNotFoundKernelException;

    public IndexReader getFreshIndexReader(SchemaIndexDescriptor var1) throws IndexNotFoundKernelException;

    public RecordCursors recordCursors();

    public long reserveNode();

    public long reserveRelationship();

    public long getGraphPropertyReference();

    public Iterator<SchemaIndexDescriptor> indexesGetForLabel(int var1);

    public Iterator<SchemaIndexDescriptor> indexesGetAll();

    public Iterator<SchemaIndexDescriptor> indexesGetRelatedToProperty(int var1);

    public Long indexGetOwningUniquenessConstraintId(SchemaIndexDescriptor var1);

    public long indexGetCommittedId(SchemaIndexDescriptor var1) throws SchemaRuleNotFoundException;

    public IntIterator graphGetPropertyKeys();

    public Object graphGetProperty(int var1);

    public Iterator<StorageProperty> graphGetAllProperties();

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor var1);

    public boolean constraintExists(ConstraintDescriptor var1);

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int var1);

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int var1);

    public Iterator<ConstraintDescriptor> constraintsGetAll();

    public PrimitiveLongResourceIterator nodesGetForLabel(int var1);

    public SchemaIndexDescriptor indexGetForSchema(SchemaDescriptor var1);

    public InternalIndexState indexGetState(SchemaIndexDescriptor var1) throws IndexNotFoundKernelException;

    public IndexProvider.Descriptor indexGetProviderDescriptor(SchemaIndexDescriptor var1) throws IndexNotFoundKernelException;

    public CapableIndexReference indexReference(SchemaIndexDescriptor var1) throws IndexNotFoundKernelException;

    public PopulationProgress indexGetPopulationProgress(SchemaDescriptor var1) throws IndexNotFoundKernelException;

    public String indexGetFailure(SchemaDescriptor var1) throws IndexNotFoundKernelException;

    public int labelGetForName(String var1);

    public String labelGetName(long var1) throws LabelNotFoundKernelException;

    public int propertyKeyGetForName(String var1);

    public int propertyKeyGetOrCreateForName(String var1);

    public String propertyKeyGetName(int var1) throws PropertyKeyIdNotFoundKernelException;

    public Iterator<Token> propertyKeyGetAllTokens();

    public Iterator<Token> labelsGetAllTokens();

    public Iterator<Token> relationshipTypeGetAllTokens();

    public int relationshipTypeGetForName(String var1);

    public String relationshipTypeGetName(int var1) throws RelationshipTypeIdNotFoundKernelException;

    public int labelGetOrCreateForName(String var1) throws TooManyLabelsException;

    public int relationshipTypeGetOrCreateForName(String var1);

    public <EXCEPTION extends Exception> void relationshipVisit(long var1, RelationshipVisitor<EXCEPTION> var3) throws EntityNotFoundException, EXCEPTION;

    public LongIterator nodesGetAll();

    public RelationshipIterator relationshipsGetAll();

    public Cursor<RelationshipItem> nodeGetRelationships(NodeItem var1, Direction var2);

    public Cursor<RelationshipItem> nodeGetRelationships(NodeItem var1, Direction var2, IntPredicate var3);

    public Cursor<PropertyItem> nodeGetProperties(NodeItem var1, AssertOpen var2);

    public Cursor<PropertyItem> nodeGetProperty(NodeItem var1, int var2, AssertOpen var3);

    public Cursor<PropertyItem> relationshipGetProperties(RelationshipItem var1, AssertOpen var2);

    public Cursor<PropertyItem> relationshipGetProperty(RelationshipItem var1, int var2, AssertOpen var3);

    public void releaseNode(long var1);

    public void releaseRelationship(long var1);

    public long countsForNode(int var1);

    public long countsForRelationship(int var1, int var2, int var3);

    public long indexSize(SchemaDescriptor var1) throws IndexNotFoundKernelException;

    public double indexUniqueValuesPercentage(SchemaDescriptor var1) throws IndexNotFoundKernelException;

    public long nodesGetCount();

    public long relationshipsGetCount();

    public int labelCount();

    public int propertyKeyCount();

    public int relationshipTypeCount();

    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor var1, Register.DoubleLongRegister var2) throws IndexNotFoundKernelException;

    public Register.DoubleLongRegister indexSample(SchemaDescriptor var1, Register.DoubleLongRegister var2) throws IndexNotFoundKernelException;

    public boolean nodeExists(long var1);

    public boolean relationshipExists(long var1);

    public IntSet relationshipTypes(NodeItem var1);

    public void degrees(NodeItem var1, DegreeVisitor var2);

    public int degreeRelationshipsInGroup(long var1, long var3, Direction var5, Integer var6);

    public <T> T getOrCreateSchemaDependantState(Class<T> var1, Function<StorageReader, T> var2);

    public Nodes nodes();

    public Relationships relationships();

    public Groups groups();

    public Properties properties();

    public static interface Properties
    extends RecordReads<PropertyRecord> {
        public PageCursor openStringPageCursor(long var1);

        public PageCursor openArrayPageCursor(long var1);

        public ByteBuffer loadString(long var1, ByteBuffer var3, PageCursor var4);

        public ByteBuffer loadArray(long var1, ByteBuffer var3, PageCursor var4);
    }

    public static interface Groups
    extends RecordReads<RelationshipGroupRecord> {
    }

    public static interface Relationships
    extends RecordReads<RelationshipRecord> {
    }

    public static interface Nodes
    extends RecordReads<NodeRecord> {
        public RecordCursor<DynamicRecord> newLabelCursor();
    }

    public static interface RecordReads<RECORD> {
        public PageCursor openPageCursorForReading(long var1);

        public void getRecordByCursor(long var1, RECORD var3, RecordLoad var4, PageCursor var5) throws InvalidRecordException;

        public long getHighestPossibleIdInUse();
    }
}

