/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;

public class PropertyLoader {
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final MetaDataStore metaDataStore;

    public PropertyLoader(NeoStores neoStores) {
        this.nodeStore = neoStores.getNodeStore();
        this.metaDataStore = neoStores.getMetaDataStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.propertyStore = neoStores.getPropertyStore();
    }

    public <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER nodeLoadProperties(long nodeId, RECEIVER receiver) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.NORMAL);
        this.loadProperties(nodeRecord.getNextProp(), receiver);
        return receiver;
    }

    public <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER nodeLoadProperties(NodeRecord node, LongObjectMap<PropertyRecord> propertiesById, RECEIVER receiver) {
        return this.loadProperties(node.getNextProp(), propertiesById, receiver);
    }

    public <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER relLoadProperties(long relId, RECEIVER receiver) {
        RelationshipRecord relRecord = (RelationshipRecord)this.relationshipStore.getRecord(relId, this.relationshipStore.newRecord(), RecordLoad.NORMAL);
        return this.loadProperties(relRecord.getNextProp(), receiver);
    }

    public <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER graphLoadProperties(RECEIVER records) {
        return this.loadProperties(this.metaDataStore.graphPropertyRecord().getNextProp(), records);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER loadProperties(long nextProp, RECEIVER receiver) {
        Collection<PropertyRecord> chain = this.propertyStore.getPropertyRecordChain(nextProp);
        return this.receivePropertyChain(receiver, chain);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER loadProperties(long nextProp, LongObjectMap<PropertyRecord> propertiesById, RECEIVER receiver) {
        Collection<PropertyRecord> chain = this.propertyStore.getPropertyRecordChain(nextProp, propertiesById);
        return this.receivePropertyChain(receiver, chain);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> RECEIVER receivePropertyChain(RECEIVER receiver, Collection<PropertyRecord> chain) {
        if (chain != null) {
            for (PropertyRecord propRecord : chain) {
                for (PropertyBlock propBlock : propRecord) {
                    receiver.receive((PropertyKeyValue)propBlock.newPropertyKeyValue(this.propertyStore), propRecord.getId());
                }
            }
        }
        return receiver;
    }
}

