/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class StorePropertyPayloadCursor {
    private static final int MAX_BYTES_IN_SHORT_STRING_OR_SHORT_ARRAY = 32;
    private static final int INTERNAL_BYTE_ARRAY_SIZE = 4096;
    private static final int INITIAL_POSITION = -1;
    private final ByteBuffer cachedBuffer;
    private final RecordCursor<DynamicRecord> stringRecordCursor;
    private final RecordCursor<DynamicRecord> arrayRecordCursor;
    private ByteBuffer buffer;
    private long[] data;
    private int position;
    private int numberOfBlocks;
    private boolean exhausted;

    StorePropertyPayloadCursor(RecordCursor<DynamicRecord> stringRecordCursor, RecordCursor<DynamicRecord> arrayRecordCursor) {
        this.buffer = this.cachedBuffer = ByteBuffer.allocate(4096);
        this.position = -1;
        this.stringRecordCursor = stringRecordCursor;
        this.arrayRecordCursor = arrayRecordCursor;
    }

    void init(long[] blocks, int numberOfBlocks) {
        this.position = -1;
        this.buffer = this.cachedBuffer;
        this.data = blocks;
        this.numberOfBlocks = numberOfBlocks;
        this.exhausted = false;
    }

    void clear() {
        this.position = -1;
        this.numberOfBlocks = 0;
        this.exhausted = false;
        this.buffer = this.cachedBuffer;
    }

    boolean next() {
        if (this.exhausted) {
            return false;
        }
        if (this.position == -1) {
            this.position = 0;
        } else if (this.position < this.numberOfBlocks) {
            this.position += this.currentBlocksUsed();
        }
        if (this.position >= this.numberOfBlocks || this.type() == null) {
            this.exhausted = true;
            return false;
        }
        return true;
    }

    PropertyType type() {
        long propBlock = this.currentHeader();
        return PropertyType.getPropertyTypeOrNull(propBlock);
    }

    int propertyKeyId() {
        return PropertyBlock.keyIndexId(this.currentHeader());
    }

    private BooleanValue booleanValue() {
        this.assertOfType(PropertyType.BOOL);
        return Values.booleanValue((PropertyBlock.fetchByte(this.currentHeader()) == 1 ? 1 : 0) != 0);
    }

    private ByteValue byteValue() {
        this.assertOfType(PropertyType.BYTE);
        return Values.byteValue((byte)PropertyBlock.fetchByte(this.currentHeader()));
    }

    private ShortValue shortValue() {
        this.assertOfType(PropertyType.SHORT);
        return Values.shortValue((short)PropertyBlock.fetchShort(this.currentHeader()));
    }

    private CharValue charValue() {
        this.assertOfType(PropertyType.CHAR);
        return Values.charValue((char)((char)PropertyBlock.fetchShort(this.currentHeader())));
    }

    private IntValue intValue() {
        this.assertOfType(PropertyType.INT);
        return Values.intValue((int)PropertyBlock.fetchInt(this.currentHeader()));
    }

    private FloatValue floatValue() {
        this.assertOfType(PropertyType.FLOAT);
        return Values.floatValue((float)Float.intBitsToFloat(PropertyBlock.fetchInt(this.currentHeader())));
    }

    private LongValue longValue() {
        this.assertOfType(PropertyType.LONG);
        if (PropertyBlock.valueIsInlined(this.currentHeader())) {
            return Values.longValue((long)(PropertyBlock.fetchLong(this.currentHeader()) >>> 1));
        }
        return Values.longValue((long)this.data[this.position + 1]);
    }

    private DoubleValue doubleValue() {
        this.assertOfType(PropertyType.DOUBLE);
        return Values.doubleValue((double)Double.longBitsToDouble(this.data[this.position + 1]));
    }

    private TextValue shortStringValue() {
        this.assertOfType(PropertyType.SHORT_STRING);
        return LongerShortString.decode(this.data, this.position, this.currentBlocksUsed());
    }

    TextValue stringValue() {
        this.assertOfType(PropertyType.STRING);
        this.readFromStore(this.stringRecordCursor);
        this.buffer.flip();
        return Values.stringValue((String)UTF8.decode((byte[])this.buffer.array(), (int)0, (int)this.buffer.limit()));
    }

    private Value shortArrayValue() {
        this.assertOfType(PropertyType.SHORT_ARRAY);
        Bits bits = this.valueAsBits();
        return ShortArray.decode(bits);
    }

    Value arrayValue() {
        this.assertOfType(PropertyType.ARRAY);
        this.readFromStore(this.arrayRecordCursor);
        this.buffer.flip();
        return PropertyStore.readArrayFromBuffer(this.buffer);
    }

    Value geometryValue() {
        this.assertOfType(PropertyType.GEOMETRY);
        return GeometryType.decode(this.data, this.position);
    }

    Value temporalValue() {
        this.assertOfType(PropertyType.TEMPORAL);
        return TemporalType.decode(this.data, this.position);
    }

    Value value() {
        switch (this.type()) {
            case BOOL: {
                return this.booleanValue();
            }
            case BYTE: {
                return this.byteValue();
            }
            case SHORT: {
                return this.shortValue();
            }
            case CHAR: {
                return this.charValue();
            }
            case INT: {
                return this.intValue();
            }
            case LONG: {
                return this.longValue();
            }
            case FLOAT: {
                return this.floatValue();
            }
            case DOUBLE: {
                return this.doubleValue();
            }
            case SHORT_STRING: {
                return this.shortStringValue();
            }
            case STRING: {
                return this.stringValue();
            }
            case SHORT_ARRAY: {
                return this.shortArrayValue();
            }
            case ARRAY: {
                return this.arrayValue();
            }
            case GEOMETRY: {
                return this.geometryValue();
            }
            case TEMPORAL: {
                return this.temporalValue();
            }
        }
        throw new IllegalStateException("No such type:" + (Object)((Object)this.type()));
    }

    private long currentHeader() {
        return this.data[this.position];
    }

    private int currentBlocksUsed() {
        return this.type().calculateNumberOfBlocksUsed(this.currentHeader());
    }

    private Bits valueAsBits() {
        Bits bits = Bits.bits(32);
        int blocksUsed = this.currentBlocksUsed();
        for (int i = 0; i < blocksUsed; ++i) {
            bits.put(this.data[this.position + i]);
        }
        return bits;
    }

    private void readFromStore(RecordCursor<DynamicRecord> cursor) {
        DynamicRecord dynamicRecord;
        this.buffer.clear();
        long startBlockId = PropertyBlock.fetchLong(this.currentHeader());
        cursor.placeAt(startBlockId, RecordLoad.FORCE);
        do {
            cursor.next();
            dynamicRecord = (DynamicRecord)cursor.get();
            byte[] data = dynamicRecord.getData();
            if (this.buffer.remaining() < data.length) {
                this.buffer.flip();
                ByteBuffer newBuffer = this.newBiggerBuffer(data.length);
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            this.buffer.put(data, 0, data.length);
        } while (!Record.NULL_REFERENCE.is(dynamicRecord.getNextBlock()));
    }

    private ByteBuffer newBiggerBuffer(int requiredCapacity) {
        int newCapacity;
        while ((newCapacity = this.buffer.capacity() * 2) - this.buffer.limit() < requiredCapacity) {
        }
        return ByteBuffer.allocate(newCapacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void assertOfType(PropertyType expected) {
        assert (this.type() == expected) : "Expected type " + (Object)((Object)expected) + " but was " + (Object)((Object)this.type());
    }
}

