/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.values.storable.ValueGroup;

interface SlotSelector {
    public static final int INSTANCE_COUNT = 5;
    public static final int UNKNOWN = -1;
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int SPATIAL = 2;
    public static final int TEMPORAL = 3;
    public static final int LUCENE = 4;

    public void validateSatisfied(IndexProvider[] var1);

    public <V> int selectSlot(V[] var1, Function<V, ValueGroup> var2);

    public static void validateSelectorInstances(Object[] instances, int ... aliveIndex) {
        for (int i = 0; i < instances.length; ++i) {
            boolean actual;
            boolean expected = ArrayUtils.contains((int[])aliveIndex, (int)i);
            boolean bl = actual = instances[i] != IndexProvider.EMPTY;
            if (expected == actual) continue;
            throw new IllegalArgumentException(String.format("Only indexes expected to be separated from IndexProvider.EMPTY are %s but was %s", Arrays.toString(aliveIndex), Arrays.toString(instances)));
        }
    }
}

