/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;

class StringLayout
extends SchemaLayout<StringSchemaKey> {
    StringLayout() {
        super("USI", 0, 1);
    }

    public StringSchemaKey newKey() {
        return new StringSchemaKey();
    }

    public StringSchemaKey copyKey(StringSchemaKey key, StringSchemaKey into) {
        into.copyFrom(key);
        return into;
    }

    public int keySize(StringSchemaKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, StringSchemaKey key) {
        cursor.putLong(key.getEntityId());
        cursor.putBytes(key.bytes, 0, key.bytesLength);
    }

    public void readKey(PageCursor cursor, StringSchemaKey into, int keySize) {
        if (keySize < 8) {
            into.setEntityId(Long.MIN_VALUE);
            into.setBytesLength(0);
            return;
        }
        into.setEntityId(cursor.getLong());
        int bytesLength = keySize - 8;
        into.setBytesLength(bytesLength);
        cursor.getBytes(into.bytes, 0, bytesLength);
    }

    @Override
    public boolean fixedSize() {
        return false;
    }

    public String toString() {
        return String.format("%s[version:%d.%d, identifier:%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.majorVersion(), this.minorVersion(), this.identifier());
    }

    @Override
    int compareValue(StringSchemaKey o1, StringSchemaKey o2) {
        return o1.compareValueTo(o2);
    }
}

