/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.TerminationGuard;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.dbms.NonTransactionalDbmsOperations;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.cache.VmPauseMonitorComponent;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.PublishPageCacheTracerMetricsAfterStart;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureGDSFactory;
import org.neo4j.kernel.impl.proc.ProcedureTransactionProvider;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.TerminationGuardProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.procedure.ProcedureTransaction;

public class DataSourceModule {
    public final ThreadToStatementContextBridge threadToTransactionBridge;
    public final NeoStoreDataSource neoStoreDataSource;
    public final Supplier<InwardKernel> kernelAPI;
    public final Supplier<QueryExecutionEngine> queryExecutor;
    public final KernelEventHandlers kernelEventHandlers;
    public final TransactionEventHandlers transactionEventHandlers;
    public final Supplier<StoreId> storeId;
    public final AutoIndexing autoIndexing;
    public final Guard guard;

    public DataSourceModule(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryExecutionEngineSupplier) {
        Dependencies deps = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        RelationshipTypeTokenHolder relationshipTypeTokenHolder = editionModule.relationshipTypeTokenHolder;
        File storeDir = platformModule.storeDir;
        DiagnosticsManager diagnosticsManager = platformModule.diagnosticsManager;
        this.queryExecutor = queryExecutionEngineSupplier;
        this.threadToTransactionBridge = (ThreadToStatementContextBridge)deps.satisfyDependency(life.add((Lifecycle)new ThreadToStatementContextBridge()));
        deps.satisfyDependency(graphDatabaseFacade);
        this.transactionEventHandlers = new TransactionEventHandlers(graphDatabaseFacade);
        diagnosticsManager.prependProvider(config);
        life.add((Lifecycle)platformModule.kernelExtensions);
        PageCache pageCache = platformModule.pageCache;
        StartupStatisticsProvider startupStatistics = deps.satisfyDependency(new StartupStatisticsProvider());
        SchemaWriteGuard schemaWriteGuard = deps.satisfyDependency(editionModule.schemaWriteGuard);
        this.guard = this.createGuard(deps);
        this.kernelEventHandlers = new KernelEventHandlers(logging.getInternalLog(KernelEventHandlers.class));
        DatabasePanicEventGenerator databasePanicEventGenerator = deps.satisfyDependency(new DatabasePanicEventGenerator(this.kernelEventHandlers));
        DatabaseHealth databaseHealth = deps.satisfyDependency(new DatabaseHealth(databasePanicEventGenerator, logging.getInternalLog(DatabaseHealth.class)));
        this.autoIndexing = new InternalAutoIndexing(platformModule.config, editionModule.propertyKeyTokenHolder);
        Procedures procedures = this.setupProcedures(platformModule, editionModule);
        deps.satisfyDependency(new NonTransactionalDbmsOperations(procedures));
        editionModule.setupSecurityModule(platformModule, procedures);
        NonTransactionalTokenNameLookup tokenNameLookup = new NonTransactionalTokenNameLookup(editionModule.labelTokenHolder, editionModule.relationshipTypeTokenHolder, editionModule.propertyKeyTokenHolder);
        CollectionsFactorySupplier collectionsFactorySupplier = this.createCollectionsFactorySupplier(config);
        this.neoStoreDataSource = deps.satisfyDependency(new NeoStoreDataSource(storeDir, config, editionModule.idGeneratorFactory, logging, platformModule.jobScheduler, tokenNameLookup, (DependencyResolver)deps, editionModule.propertyKeyTokenHolder, editionModule.labelTokenHolder, relationshipTypeTokenHolder, editionModule.statementLocksFactory, schemaWriteGuard, this.transactionEventHandlers, platformModule.monitors.newMonitor(IndexingService.Monitor.class, new String[0]), fileSystem, platformModule.transactionMonitor, databaseHealth, platformModule.monitors.newMonitor(LogFileCreationMonitor.class, new String[0]), editionModule.headerInformationFactory, startupStatistics, editionModule.commitProcessFactory, this.autoIndexing, pageCache, editionModule.constraintSemantics, platformModule.monitors, platformModule.tracers, procedures, editionModule.ioLimiter, platformModule.availabilityGuard, platformModule.clock, editionModule.accessCapability, platformModule.storeCopyCheckPointMutex, platformModule.recoveryCleanupWorkCollector, editionModule.idController, platformModule.databaseInfo.operationalMode, platformModule.versionContextSupplier, collectionsFactorySupplier));
        dataSourceManager.register(this.neoStoreDataSource);
        life.add((Lifecycle)new VmPauseMonitorComponent(config, logging.getInternalLog(VmPauseMonitorComponent.class), platformModule.jobScheduler));
        life.add((Lifecycle)new PublishPageCacheTracerMetricsAfterStart(platformModule.tracers.pageCursorTracerSupplier));
        life.add((Lifecycle)new DatabaseAvailability(platformModule.availabilityGuard, platformModule.transactionMonitor, config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout).toMillis()));
        life.add((Lifecycle)new StartupWaiter(platformModule.availabilityGuard, editionModule.transactionStartTimeout));
        life.add((Lifecycle)this.kernelEventHandlers);
        this.storeId = this.neoStoreDataSource::getStoreId;
        this.kernelAPI = this.neoStoreDataSource::getKernel;
        ProcedureGDSFactory gdsFactory = new ProcedureGDSFactory(platformModule, editionModule, this, (DependencyResolver)deps, editionModule.coreAPIAvailabilityGuard, editionModule.relationshipTypeTokenHolder);
        procedures.registerComponent(GraphDatabaseService.class, gdsFactory::apply, true);
    }

    private CollectionsFactorySupplier createCollectionsFactorySupplier(Config config) {
        GraphDatabaseSettings.TransactionStateMemoryAllocation allocation = config.get(GraphDatabaseSettings.tx_state_memory_allocation);
        switch (allocation) {
            case ON_HEAP: {
                return CollectionsFactorySupplier.ON_HEAP;
            }
            case OFF_HEAP: {
                return CollectionsFactorySupplier.OFF_HEAP;
            }
        }
        throw new IllegalArgumentException("Unknown transaction state memory allocation value: " + (Object)((Object)allocation));
    }

    private Guard createGuard(Dependencies deps) {
        TerminationGuard guard = this.createGuard();
        deps.satisfyDependency(guard);
        return guard;
    }

    protected TerminationGuard createGuard() {
        return new TerminationGuard();
    }

    private Procedures setupProcedures(PlatformModule platform, EditionModule editionModule) {
        File pluginDir = platform.config.get(GraphDatabaseSettings.plugin_dir);
        Log internalLog = platform.logging.getInternalLog(Procedures.class);
        EmbeddedProxySPI proxySPI = (EmbeddedProxySPI)platform.dependencies.resolveDependency(EmbeddedProxySPI.class);
        ProcedureConfig procedureConfig = new ProcedureConfig(platform.config);
        Procedures procedures = new Procedures(proxySPI, new SpecialBuiltInProcedures(Version.getNeo4jVersion(), platform.databaseInfo.edition.toString()), pluginDir, internalLog, procedureConfig);
        platform.life.add((Lifecycle)procedures);
        platform.dependencies.satisfyDependency(procedures);
        procedures.registerType(Node.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
        procedures.registerType(Relationship.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
        procedures.registerType(Path.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
        procedures.registerType(Geometry.class, (Neo4jTypes.AnyType)Neo4jTypes.NTGeometry);
        procedures.registerType(Point.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPoint);
        Log proceduresLog = platform.logging.getUserLog(Procedures.class);
        procedures.registerComponent(Log.class, ctx -> proceduresLog, true);
        Guard guard = (Guard)platform.dependencies.resolveDependency(Guard.class);
        procedures.registerComponent(ProcedureTransaction.class, new ProcedureTransactionProvider(), true);
        procedures.registerComponent(org.neo4j.procedure.TerminationGuard.class, new TerminationGuardProvider(guard), true);
        procedures.registerComponent(DependencyResolver.class, ctx -> platform.dependencies, false);
        procedures.registerComponent(KernelTransaction.class, ctx -> ctx.get(Context.KERNEL_TRANSACTION), false);
        procedures.registerComponent(GraphDatabaseAPI.class, ctx -> platform.graphDatabaseFacade, false);
        procedures.registerComponent(SecurityContext.class, ctx -> ctx.get(Context.SECURITY_CONTEXT), true);
        try {
            editionModule.registerProcedures(procedures, procedureConfig);
        }
        catch (KernelException e) {
            internalLog.error("Failed to register built-in edition procedures at start up: " + e.getMessage());
        }
        return procedures;
    }

    private static class StartupWaiter
    extends LifecycleAdapter {
        private final AvailabilityGuard availabilityGuard;
        private final long timeout;

        StartupWaiter(AvailabilityGuard availabilityGuard, long timeout) {
            this.availabilityGuard = availabilityGuard;
            this.timeout = timeout;
        }

        public void start() {
            this.availabilityGuard.isAvailable(this.timeout);
        }
    }
}

