/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCache {
    private final Lock cacheUpdateLock = new StampedLock().asWriteLock();
    private volatile SchemaCacheState schemaCacheState;

    public SchemaCache(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> initialRules) {
        this.schemaCacheState = new SchemaCacheState(constraintSemantics, initialRules);
    }

    public Iterable<IndexRule> indexRules() {
        return this.schemaCacheState.indexRules();
    }

    public Iterable<ConstraintRule> constraintRules() {
        return this.schemaCacheState.constraintRules();
    }

    public boolean hasConstraintRule(Long constraintRuleId) {
        return this.schemaCacheState.hasConstraintRule(constraintRuleId);
    }

    public boolean hasConstraintRule(ConstraintDescriptor descriptor) {
        return this.schemaCacheState.hasConstraintRule(descriptor);
    }

    public boolean hasIndexRule(SchemaDescriptor descriptor) {
        return this.schemaCacheState.hasIndexRule(descriptor);
    }

    public Iterator<ConstraintDescriptor> constraints() {
        return this.schemaCacheState.constraints();
    }

    public Iterator<ConstraintDescriptor> constraintsForLabel(int label) {
        return Iterators.filter((Predicate)SchemaDescriptorPredicates.hasLabel((int)label), this.constraints());
    }

    public Iterator<ConstraintDescriptor> constraintsForRelationshipType(int relTypeId) {
        return Iterators.filter((Predicate)SchemaDescriptorPredicates.hasRelType((int)relTypeId), this.constraints());
    }

    public Iterator<ConstraintDescriptor> constraintsForSchema(SchemaDescriptor descriptor) {
        return Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)descriptor), this.constraints());
    }

    public <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
        return this.schemaCacheState.getOrCreateDependantState(type, factory, parameter);
    }

    public void load(Iterable<SchemaRule> rules) {
        this.cacheUpdateLock.lock();
        try {
            ConstraintSemantics constraintSemantics = this.schemaCacheState.constraintSemantics;
            this.schemaCacheState = new SchemaCacheState(constraintSemantics, rules);
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    public void addSchemaRule(SchemaRule rule) {
        this.cacheUpdateLock.lock();
        try {
            SchemaCacheState updatedSchemaState = new SchemaCacheState(this.schemaCacheState);
            updatedSchemaState.addSchemaRule(rule);
            this.schemaCacheState = updatedSchemaState;
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaRule(long id) {
        this.cacheUpdateLock.lock();
        try {
            SchemaCacheState updatedSchemaState = new SchemaCacheState(this.schemaCacheState);
            updatedSchemaState.removeSchemaRule(id);
            this.schemaCacheState = updatedSchemaState;
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    public SchemaIndexDescriptor indexDescriptor(SchemaDescriptor descriptor) {
        return this.schemaCacheState.indexDescriptor(descriptor);
    }

    public Iterator<SchemaIndexDescriptor> indexDescriptorsForLabel(int labelId) {
        return this.schemaCacheState.indexDescriptorsForLabel(labelId);
    }

    public Iterator<SchemaIndexDescriptor> indexesByProperty(int propertyId) {
        return this.schemaCacheState.indexesByProperty(propertyId);
    }

    private static class SchemaCacheState {
        private final ConstraintSemantics constraintSemantics;
        private final Set<ConstraintDescriptor> constraints;
        private final MutableLongObjectMap<IndexRule> indexRuleById;
        private final MutableLongObjectMap<ConstraintRule> constraintRuleById;
        private final Map<SchemaDescriptor, SchemaIndexDescriptor> indexDescriptors;
        private final MutableIntObjectMap<Set<SchemaIndexDescriptor>> indexDescriptorsByLabel;
        private final Map<Class<?>, Object> dependantState;
        private final MutableIntObjectMap<List<SchemaIndexDescriptor>> indexByProperty;

        SchemaCacheState(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> rules) {
            this.constraintSemantics = constraintSemantics;
            this.constraints = new HashSet<ConstraintDescriptor>();
            this.indexRuleById = new LongObjectHashMap();
            this.constraintRuleById = new LongObjectHashMap();
            this.indexDescriptors = new HashMap<SchemaDescriptor, SchemaIndexDescriptor>();
            this.indexDescriptorsByLabel = new IntObjectHashMap();
            this.dependantState = new ConcurrentHashMap();
            this.indexByProperty = new IntObjectHashMap();
            this.load(rules);
        }

        SchemaCacheState(SchemaCacheState schemaCacheState) {
            this.constraintSemantics = schemaCacheState.constraintSemantics;
            this.indexRuleById = LongObjectHashMap.newMap(schemaCacheState.indexRuleById);
            this.constraintRuleById = LongObjectHashMap.newMap(schemaCacheState.constraintRuleById);
            this.constraints = new HashSet<ConstraintDescriptor>(schemaCacheState.constraints);
            this.indexDescriptors = new HashMap<SchemaDescriptor, SchemaIndexDescriptor>(schemaCacheState.indexDescriptors);
            this.indexDescriptorsByLabel = IntObjectHashMap.newMap(schemaCacheState.indexDescriptorsByLabel);
            this.dependantState = new ConcurrentHashMap();
            this.indexByProperty = IntObjectHashMap.newMap(schemaCacheState.indexByProperty);
        }

        private void load(Iterable<SchemaRule> schemaRuleIterator) {
            for (SchemaRule schemaRule : schemaRuleIterator) {
                this.addSchemaRule(schemaRule);
            }
        }

        Iterable<IndexRule> indexRules() {
            return this.indexRuleById.values();
        }

        Iterable<ConstraintRule> constraintRules() {
            return this.constraintRuleById.values();
        }

        boolean hasConstraintRule(Long constraintRuleId) {
            return constraintRuleId != null && this.constraintRuleById.containsKey(constraintRuleId.longValue());
        }

        boolean hasConstraintRule(ConstraintDescriptor descriptor) {
            return this.constraints.contains(descriptor);
        }

        boolean hasIndexRule(SchemaDescriptor descriptor) {
            return this.indexDescriptors.containsKey(descriptor);
        }

        Iterator<ConstraintDescriptor> constraints() {
            return this.constraints.iterator();
        }

        SchemaIndexDescriptor indexDescriptor(SchemaDescriptor descriptor) {
            return this.indexDescriptors.get(descriptor);
        }

        Iterator<SchemaIndexDescriptor> indexesByProperty(int propertyId) {
            List indexes = (List)this.indexByProperty.get(propertyId);
            return indexes == null ? Collections.emptyIterator() : indexes.iterator();
        }

        Iterator<SchemaIndexDescriptor> indexDescriptorsForLabel(int labelId) {
            Set forLabel = (Set)this.indexDescriptorsByLabel.get(labelId);
            return forLabel == null ? Collections.emptyIterator() : forLabel.iterator();
        }

        <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
            return type.cast(this.dependantState.computeIfAbsent(type, key -> factory.apply(parameter)));
        }

        void addSchemaRule(SchemaRule rule) {
            if (rule instanceof ConstraintRule) {
                ConstraintRule constraintRule = (ConstraintRule)rule;
                this.constraintRuleById.put(constraintRule.getId(), (Object)constraintRule);
                this.constraints.add(this.constraintSemantics.readConstraint(constraintRule));
            } else if (rule instanceof IndexRule) {
                IndexRule indexRule = (IndexRule)rule;
                this.indexRuleById.put(indexRule.getId(), (Object)indexRule);
                SchemaDescriptor schemaDescriptor = indexRule.schema();
                SchemaIndexDescriptor schemaIndexDescriptor = indexRule.getIndexDescriptor();
                this.indexDescriptors.put(schemaDescriptor, schemaIndexDescriptor);
                Set forLabel = (Set)this.indexDescriptorsByLabel.getIfAbsentPut(schemaDescriptor.keyId(), HashSet::new);
                forLabel.add(schemaIndexDescriptor);
                for (int propertyId : indexRule.schema().getPropertyIds()) {
                    List indexesForProperty = (List)this.indexByProperty.getIfAbsentPut(propertyId, ArrayList::new);
                    indexesForProperty.add(schemaIndexDescriptor);
                }
            }
        }

        void removeSchemaRule(long id) {
            if (this.constraintRuleById.containsKey(id)) {
                ConstraintRule rule = (ConstraintRule)this.constraintRuleById.remove(id);
                this.constraints.remove(rule.getConstraintDescriptor());
            } else if (this.indexRuleById.containsKey(id)) {
                IndexRule rule = (IndexRule)this.indexRuleById.remove(id);
                SchemaDescriptor schema = rule.schema();
                this.indexDescriptors.remove(schema);
                Set forLabel = (Set)this.indexDescriptorsByLabel.get(schema.keyId());
                forLabel.remove(rule.getIndexDescriptor());
                if (forLabel.isEmpty()) {
                    this.indexDescriptorsByLabel.remove(schema.keyId());
                }
                for (int propertyId : rule.schema().getPropertyIds()) {
                    List forProperty = (List)this.indexByProperty.get(propertyId);
                    forProperty.remove(rule.getIndexDescriptor());
                    if (!forProperty.isEmpty()) continue;
                    this.indexByProperty.remove(propertyId);
                }
            }
        }
    }
}

