/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.scheduler.JobScheduler;

public class IndexSamplingController {
    private final IndexSamplingJobFactory jobFactory;
    private final IndexSamplingJobQueue<Long> jobQueue;
    private final IndexSamplingJobTracker jobTracker;
    private final IndexMapSnapshotProvider indexMapSnapshotProvider;
    private final JobScheduler scheduler;
    private final RecoveryCondition indexRecoveryCondition;
    private final boolean backgroundSampling;
    private final Lock samplingLock = new ReentrantLock();
    private JobScheduler.JobHandle backgroundSamplingHandle;

    IndexSamplingController(IndexSamplingConfig config, IndexSamplingJobFactory jobFactory, IndexSamplingJobQueue<Long> jobQueue, IndexSamplingJobTracker jobTracker, IndexMapSnapshotProvider indexMapSnapshotProvider, JobScheduler scheduler, RecoveryCondition indexRecoveryCondition) {
        this.backgroundSampling = config.backgroundSampling();
        this.jobFactory = jobFactory;
        this.indexMapSnapshotProvider = indexMapSnapshotProvider;
        this.jobQueue = jobQueue;
        this.jobTracker = jobTracker;
        this.scheduler = scheduler;
        this.indexRecoveryCondition = indexRecoveryCondition;
    }

    public void sampleIndexes(IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        this.jobQueue.addAll(!mode.sampleOnlyIfUpdated, PrimitiveLongCollections.toIterator((LongIterator)indexMap.indexIds()));
        this.scheduleSampling(mode, indexMap);
    }

    public void sampleIndex(long indexId, IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        this.jobQueue.add(!mode.sampleOnlyIfUpdated, indexId);
        this.scheduleSampling(mode, indexMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverIndexSamples() {
        this.samplingLock.lock();
        try {
            IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
            LongIterator indexIds = indexMap.indexIds();
            while (indexIds.hasNext()) {
                long indexId = indexIds.next();
                if (!this.indexRecoveryCondition.test(indexId, indexMap.getIndexProxy(indexId).getDescriptor())) continue;
                this.sampleIndexOnCurrentThread(indexMap, indexId);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private void scheduleSampling(IndexSamplingMode mode, IndexMap indexMap) {
        if (mode.blockUntilAllScheduled) {
            this.scheduleAllSampling(indexMap);
        } else {
            this.tryScheduleSampling(indexMap);
        }
    }

    private void tryScheduleSampling(IndexMap indexMap) {
        if (this.tryEmptyLock()) {
            try {
                while (this.jobTracker.canExecuteMoreSamplingJobs()) {
                    Long indexId = this.jobQueue.poll();
                    if (indexId == null) {
                        return;
                    }
                    this.sampleIndexOnTracker(indexMap, indexId);
                }
            }
            finally {
                this.samplingLock.unlock();
            }
        }
    }

    private boolean tryEmptyLock() {
        try {
            return this.samplingLock.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAllSampling(IndexMap indexMap) {
        this.samplingLock.lock();
        try {
            Iterable<Long> indexIds = this.jobQueue.pollAll();
            for (Long indexId : indexIds) {
                this.jobTracker.waitUntilCanExecuteMoreSamplingJobs();
                this.sampleIndexOnTracker(indexMap, indexId);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private void sampleIndexOnTracker(IndexMap indexMap, long indexId) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, indexId);
        if (job != null) {
            this.jobTracker.scheduleSamplingJob(job);
        }
    }

    private void sampleIndexOnCurrentThread(IndexMap indexMap, long indexId) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, indexId);
        if (job != null) {
            job.run();
        }
    }

    private IndexSamplingJob createSamplingJob(IndexMap indexMap, long indexId) {
        IndexProxy proxy = indexMap.getIndexProxy(indexId);
        if (proxy == null || proxy.getState() != InternalIndexState.ONLINE) {
            return null;
        }
        return this.jobFactory.create(indexId, proxy);
    }

    public void start() {
        if (this.backgroundSampling) {
            Runnable samplingRunner = () -> this.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
            this.backgroundSamplingHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.indexSamplingController, samplingRunner, 10L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.backgroundSamplingHandle != null) {
            this.backgroundSamplingHandle.cancel(true);
        }
        this.jobTracker.stopAndAwaitAllJobs();
    }

    public static interface RecoveryCondition {
        public boolean test(long var1, SchemaIndexDescriptor var3);
    }
}

