/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodeUpdates;

class NodeUpdatesIterator
implements Iterator<NodeUpdates> {
    private final IndexStoreView storeView;
    private final LongIterator nodeIdIterator;
    private NodeUpdates nextUpdate;

    NodeUpdatesIterator(IndexStoreView storeView, LongIterator nodeIdIterator) {
        this.storeView = storeView;
        this.nodeIdIterator = nodeIdIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.nextUpdate == null) {
            while (this.nodeIdIterator.hasNext()) {
                long nodeId = this.nodeIdIterator.next();
                NodeUpdates updates = this.storeView.nodeAsUpdates(nodeId);
                if (updates == null) continue;
                this.nextUpdate = updates;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public NodeUpdates next() {
        NodeUpdates update = null;
        if (this.hasNext()) {
            update = this.nextUpdate;
            this.nextUpdate = null;
        }
        return update;
    }
}

