/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Set;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.diffsets.DiffApplyingLongIterator;

class DiffApplyingRelationshipIterator
extends DiffApplyingLongIterator
implements RelationshipIterator {
    private final RelationshipVisitor.Home sourceHome;
    private final RelationshipVisitor.Home addedHome;

    DiffApplyingRelationshipIterator(RelationshipIterator source, Set<?> addedElements, Set<?> removedElements, RelationshipVisitor.Home addedHome) {
        super(source, addedElements, removedElements, null);
        this.sourceHome = source;
        this.addedHome = addedHome;
    }

    @Override
    public <EXCEPTION extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
        assert (relId == this.next);
        switch (this.phase) {
            case FILTERED_SOURCE: {
                return this.sourceHome.relationshipVisit(this.next, visitor);
            }
            case ADDED_ELEMENTS: {
                return this.addedHome.relationshipVisit(this.next, visitor);
            }
        }
        throw new IllegalStateException("Shouldn't have come here in phase " + (Object)((Object)this.phase));
    }
}

