/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.collection.Pair;

public class IndexSpecifier {
    private final String specification;
    private final String label;
    private final String[] properties;

    public IndexSpecifier(String specification) {
        this.specification = specification;
        Pair<String, String[]> components = this.parse();
        this.label = (String)components.first();
        this.properties = (String[])components.other();
    }

    public String label() {
        return this.label;
    }

    public String[] properties() {
        return this.properties;
    }

    public String toString() {
        return this.specification;
    }

    private Pair<String, String[]> parse() {
        Pattern pattern = Pattern.compile(":\\s*" + IndexSpecifier.or(IndexSpecifier.identifier(true), IndexSpecifier.qoutedIdentifier(true)) + "\\((" + IndexSpecifier.or(IndexSpecifier.identifier(false), IndexSpecifier.qoutedIdentifier(false)) + "(?:,\\s*" + IndexSpecifier.or(IndexSpecifier.identifier(false), IndexSpecifier.qoutedIdentifier(false)) + ")*)\\)");
        Matcher matcher = pattern.matcher(this.specification);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Cannot parse index specification " + this.specification);
        }
        String label = this.either(matcher.group(1), matcher.group(2));
        String propertyString = matcher.group(3);
        String[] properties = propertyString.split(",\\s*(?=(?:[^`]*`[^`]*`)*[^`]*$)");
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = properties[i].replaceAll("(^`)|(`$)", "");
        }
        return Pair.of((Object)label, (Object)properties);
    }

    private String either(String first, String second) {
        return first != null ? first : second;
    }

    private static String or(String first, String second) {
        return "(?:" + first + "|" + second + ")";
    }

    private static String identifier(boolean capture) {
        if (capture) {
            return "([A-Za-z0-9_]+)";
        }
        return "(?:[A-Za-z0-9_]+)";
    }

    private static String qoutedIdentifier(boolean capture) {
        if (capture) {
            return "(?:`((?:[^`]|``)+)`)";
        }
        return "(?:`(?:(?:[^`]|``)+)`)";
    }
}

