/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.function.LongFunction;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.unsafe.impl.batchimport.store.SecondaryUnitPrepareIdSequence;

public class SecondaryUnitPrepareIdSequenceTest {
    @Test
    public void shouldReturnIdImmediatelyAfterRecordId() {
        SecondaryUnitPrepareIdSequence idSequence = new SecondaryUnitPrepareIdSequence();
        IdSequence actual = (IdSequence)Mockito.mock(IdSequence.class);
        long recordId = 10L;
        IdSequence prepared = (IdSequence)((LongFunction)idSequence.apply((Object)actual)).apply(recordId);
        long nextRecordId = prepared.nextId();
        Assert.assertEquals((long)11L, (long)nextRecordId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual});
    }

    @Test
    public void shouldReturnIdImmediatelyAfterRecordIdOnlyOnce() {
        SecondaryUnitPrepareIdSequence idSequence = new SecondaryUnitPrepareIdSequence();
        IdSequence actual = (IdSequence)Mockito.mock(IdSequence.class);
        long recordId = 10L;
        IdSequence prepared = (IdSequence)((LongFunction)idSequence.apply((Object)actual)).apply(recordId);
        long nextRecordId = prepared.nextId();
        Assert.assertEquals((long)11L, (long)nextRecordId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual});
        try {
            prepared.nextId();
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        recordId = 20L;
        prepared = (IdSequence)((LongFunction)idSequence.apply((Object)actual)).apply(recordId);
        nextRecordId = prepared.nextId();
        Assert.assertEquals((long)21L, (long)nextRecordId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual});
    }
}

