/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.NullOutputStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputException;

public class BadCollectorTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldCollectBadRelationshipsEvenIfThresholdNeverReached() throws IOException {
        int tolerance = 5;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 7);){
            badCollector.collectBadRelationship((Object)"1", "a", "T", (Object)"2", "b", (Object)"1");
            Assert.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    public void shouldThrowExceptionIfDuplicateNodeTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 7);){
            this.collectBadRelationship((Collector)badCollector);
            try {
                badCollector.collectDuplicateNode((Object)1, 1L, "group");
                Assert.fail((String)"Should have thrown an InputException");
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldThrowExceptionIfBadRelationshipsTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 7);){
            badCollector.collectDuplicateNode((Object)1, 1L, "group");
            try {
                this.collectBadRelationship((Collector)badCollector);
                Assert.fail((String)"Should have thrown an InputException");
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldNotCollectBadRelationshipsIfWeShouldOnlyBeCollectingNodes() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 2);){
            badCollector.collectDuplicateNode((Object)1, 1L, "group");
            try {
                this.collectBadRelationship((Collector)badCollector);
            }
            catch (InputException ignored) {
                Assert.assertEquals((long)1L, (long)badCollector.badEntries());
            }
        }
    }

    @Test
    public void shouldNotCollectBadNodesIfWeShouldOnlyBeCollectingRelationships() throws IOException {
        int tolerance = 1;
        try (BadCollector badCollector = new BadCollector(this.badOutputFile(), (long)tolerance, 1);){
            this.collectBadRelationship((Collector)badCollector);
            try {
                badCollector.collectDuplicateNode((Object)1, 1L, "group");
            }
            catch (InputException ignored) {
                Assert.assertEquals((long)1L, (long)badCollector.badEntries());
            }
        }
    }

    @Test
    public void shouldCollectUnlimitedNumberOfBadEntriesIfToldTo() {
        try (BadCollector collector = new BadCollector(NullOutputStream.NULL_OUTPUT_STREAM, -1L, 7);){
            int count = 10000;
            for (int i = 0; i < count; ++i) {
                collector.collectDuplicateNode((Object)i, (long)i, "group");
            }
            Assert.assertEquals((long)count, (long)collector.badEntries());
        }
    }

    @Test
    public void skipBadEntriesLogging() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (BadCollector badCollector = new BadCollector((OutputStream)outputStream, 100L, 7, true);){
            this.collectBadRelationship((Collector)badCollector);
            for (int i = 0; i < 2; ++i) {
                badCollector.collectDuplicateNode((Object)i, (long)i, "group");
            }
            this.collectBadRelationship((Collector)badCollector);
            badCollector.collectExtraColumns("a,b,c", 1L, "a");
            Assert.assertEquals((String)"Output stream should not have any reported entries", (long)0L, (long)outputStream.size());
        }
    }

    private void collectBadRelationship(Collector collector) {
        collector.collectBadRelationship((Object)"A", Group.GLOBAL.name(), "TYPE", (Object)"B", Group.GLOBAL.name(), (Object)"A");
    }

    private OutputStream badOutputFile() throws IOException {
        File badDataPath = new File("/tmp/foo2").getAbsoluteFile();
        FileSystemAbstraction fileSystem = this.fs.get();
        File badDataFile = this.badDataFile(fileSystem, badDataPath);
        return fileSystem.openAsOutputStream(badDataFile, true);
    }

    private File badDataFile(FileSystemAbstraction fileSystem, File badDataPath) throws IOException {
        fileSystem.mkdir(badDataPath.getParentFile());
        fileSystem.create(badDataPath);
        return badDataPath;
    }
}

