/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheArrayFactoryMonitor;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;

public class PageCacheArrayFactoryMonitorTest {
    private final PageCachedNumberArrayFactory factory = new PageCachedNumberArrayFactory((PageCache)Mockito.mock(PageCache.class), new File("storeDir"));
    private final PageCacheArrayFactoryMonitor monitor = new PageCacheArrayFactoryMonitor();

    @Test
    public void shouldComposeFailureDescriptionForFailedCandidates() {
        this.monitor.allocationSuccessful(123L, (NumberArrayFactory)this.factory, Arrays.asList(new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM1"), NumberArrayFactory.HEAP), new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM2"), NumberArrayFactory.OFF_HEAP)));
        String failure = this.monitor.pageCacheAllocationOrNull();
        Assert.assertThat((Object)failure, (Matcher)Matchers.containsString((String)"OOM1"));
        Assert.assertThat((Object)failure, (Matcher)Matchers.containsString((String)"OOM2"));
    }

    @Test
    public void shouldClearFailureStateAfterAccessorCall() {
        this.monitor.allocationSuccessful(123L, (NumberArrayFactory)this.factory, Arrays.asList(new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM1"), NumberArrayFactory.HEAP), new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM2"), NumberArrayFactory.OFF_HEAP)));
        String failure = this.monitor.pageCacheAllocationOrNull();
        String secondCall = this.monitor.pageCacheAllocationOrNull();
        Assert.assertNotNull((Object)failure);
        Assert.assertNull((Object)secondCall);
    }

    @Test
    public void shouldReturnNullFailureOnNoFailure() {
        Assert.assertNull((Object)this.monitor.pageCacheAllocationOrNull());
    }
}

