/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.Utils;

public class UtilsTest {
    @Test
    public void shouldDetectCollisions() {
        long[] first = new long[]{1L, 4L, 7L, 10L, 100L, 101L};
        long[] other = new long[]{2L, 3L, 34L, 75L, 101L};
        boolean collides = Utils.anyIdCollides((long[])first, (int)first.length, (long[])other, (int)other.length);
        Assert.assertTrue((boolean)collides);
    }

    @Test
    public void shouldNotReportDisjointArraysAsCollision() {
        long[] first = new long[]{1L, 4L, 7L, 10L, 100L, 101L};
        long[] other = new long[]{2L, 3L, 34L, 75L, 102L};
        boolean collides = Utils.anyIdCollides((long[])first, (int)first.length, (long[])other, (int)other.length);
        Assert.assertFalse((boolean)collides);
    }

    @Test
    public void shouldBeCorrectForSomeRandomBatches() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long[][] batches = new long[20][];
        for (int i = 0; i < batches.length; ++i) {
            batches[i] = this.randomBatch(1000, random, 5000000);
        }
        for (long[] rBatch : batches) {
            for (long[] lBatch : batches) {
                Assert.assertEquals((Object)this.actuallyCollides(rBatch, lBatch), (Object)Utils.anyIdCollides((long[])rBatch, (int)rBatch.length, (long[])lBatch, (int)lBatch.length));
            }
        }
    }

    @Test
    public void shouldMergeIdsInto() {
        long[] values = new long[]{2L, 4L, 10L, 11L, 14L};
        long[] into = new long[]{1L, 5L, 6L, 11L, 25L};
        int intoLengthBefore = into.length;
        into = Arrays.copyOf(into, into.length + values.length);
        Utils.mergeSortedInto((long[])values, (long[])into, (int)intoLengthBefore);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 4L, 5L, 6L, 10L, 11L, 11L, 14L, 25L}, (long[])into);
    }

    @Test
    public void shouldMergeSomeRandomIdsInto() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int batchSize = 10000;
        for (int i = 0; i < 100; ++i) {
            long[] values = this.randomBatch(batchSize, random, 100000000);
            long[] into = this.randomBatch(batchSize, random, 100000000);
            long[] expectedMergedArray = this.manuallyMerge(values, into);
            into = Arrays.copyOf(into, batchSize * 2);
            Utils.mergeSortedInto((long[])values, (long[])into, (int)batchSize);
            Assert.assertArrayEquals((long[])expectedMergedArray, (long[])into);
        }
    }

    private long[] manuallyMerge(long[] values, long[] into) {
        long[] all = new long[values.length + into.length];
        System.arraycopy(values, 0, all, 0, values.length);
        System.arraycopy(into, 0, all, values.length, into.length);
        Arrays.sort(all);
        return all;
    }

    private boolean actuallyCollides(long[] b1, long[] b2) {
        for (int i = 0; i < b1.length; ++i) {
            for (int j = 0; j < b2.length; ++j) {
                if (b1[i] != b2[j]) continue;
                return true;
            }
        }
        return false;
    }

    private long[] randomBatch(int length, Random random, int max) {
        long[] result = new long[length];
        this.randomBatchInto(result, length, random, max);
        return result;
    }

    private void randomBatchInto(long[] into, int length, Random random, int max) {
        for (int i = 0; i < length; ++i) {
            into[i] = random.nextInt(max);
        }
        Arrays.sort(into, 0, length);
    }
}

