/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.store.PrepareIdSequence;
import org.neo4j.unsafe.impl.batchimport.store.StorePrepareIdSequence;

public class UpdateRecordsStepTest {
    @Test
    public void ioThroughputStatDoesNotOverflow() {
        RecordStore store = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)store.getRecordSize()).thenReturn((Object)0x3FFFFFFF);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        StageControl stageControl = (StageControl)Mockito.mock(StageControl.class);
        UpdateRecordsStep step = new UpdateRecordsStep(stageControl, configuration, store, (PrepareIdSequence)new StorePrepareIdSequence());
        NodeRecord record = new NodeRecord(1L);
        record.setInUse(true);
        Object[] batch = new NodeRecord[11];
        Arrays.fill(batch, record);
        step.process((AbstractBaseRecord[])batch, (BatchSender)Mockito.mock(BatchSender.class));
        Stat stat = step.stat((Key)Keys.io_throughput);
        Assert.assertThat((Object)stat.asLong(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void recordWithReservedIdIsSkipped() {
        RecordStore store = (RecordStore)Mockito.mock(NodeStore.class);
        StageControl stageControl = (StageControl)Mockito.mock(StageControl.class);
        UpdateRecordsStep step = new UpdateRecordsStep(stageControl, Configuration.DEFAULT, store, (PrepareIdSequence)new StorePrepareIdSequence());
        NodeRecord node1 = new NodeRecord(1L);
        node1.setInUse(true);
        NodeRecord node2 = new NodeRecord(2L);
        node2.setInUse(true);
        NodeRecord nodeWithReservedId = new NodeRecord(0xFFFFFFFFL);
        NodeRecord[] batch = new NodeRecord[]{node1, node2, nodeWithReservedId};
        step.process((AbstractBaseRecord[])batch, (BatchSender)Mockito.mock(BatchSender.class));
        ((RecordStore)Mockito.verify((Object)store)).prepareForCommit((AbstractBaseRecord)org.mockito.Matchers.eq((Object)node1), (IdSequence)org.mockito.Matchers.any(IdSequence.class));
        ((RecordStore)Mockito.verify((Object)store)).updateRecord((AbstractBaseRecord)node1);
        ((RecordStore)Mockito.verify((Object)store)).prepareForCommit((AbstractBaseRecord)org.mockito.Matchers.eq((Object)node2), (IdSequence)org.mockito.Matchers.any(IdSequence.class));
        ((RecordStore)Mockito.verify((Object)store)).updateRecord((AbstractBaseRecord)node2);
        ((RecordStore)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).prepareForCommit((AbstractBaseRecord)org.mockito.Matchers.eq((Object)nodeWithReservedId), (IdSequence)org.mockito.Matchers.any(IdSequence.class));
        ((RecordStore)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).updateRecord((AbstractBaseRecord)nodeWithReservedId);
    }
}

