/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.DataAfterQuoteException;
import org.neo4j.csv.reader.Readables;
import org.neo4j.io.NullOutputStream;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class ImportPanicIT {
    private static final int BUFFER_SIZE = 1000;
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.directory);

    @Test
    public void shouldExitAndThrowExceptionOnPanic() throws Exception {
        ParallelBatchImporter importer = new ParallelBatchImporter(this.directory.absolutePath(), this.fs, null, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), ExecutionMonitors.invisible(), AdditionalInitialIds.EMPTY, Config.defaults(), StandardV3_0.RECORD_FORMATS, ImportLogic.NO_MONITOR);
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, this.fileAsCharReadable(this.nodeCsvFileWithBrokenEntries()))});
        CsvInput brokenCsvInput = new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.csvConfigurationWithLowBufferSize(), (Collector)new BadCollector(NullOutputStream.NULL_OUTPUT_STREAM, 0L, 0));
        try {
            importer.doImport((Input)brokenCsvInput);
            Assert.fail((String)"Should have failed properly");
        }
        catch (InputException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof DataAfterQuoteException));
        }
    }

    private org.neo4j.unsafe.impl.batchimport.input.csv.Configuration csvConfigurationWithLowBufferSize() {
        return new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS){

            public int bufferSize() {
                return 1000;
            }
        };
    }

    private Supplier<CharReadable> fileAsCharReadable(File file) {
        return () -> {
            try {
                return Readables.files((Charset)StandardCharsets.UTF_8, (File[])new File[]{file});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private File nodeCsvFileWithBrokenEntries() throws IOException {
        File file = this.directory.file("broken-node-data.csv");
        try (PrintWriter writer = new PrintWriter(this.fs.openAsWriter(file, StandardCharsets.UTF_8, false));){
            writer.println(":ID,name");
            int numberOfLines = 10000;
            int brokenLine = this.random.nextInt(numberOfLines);
            for (int i = 0; i < numberOfLines; ++i) {
                if (i == brokenLine) {
                    writer.println(i + ",\"broken\"line");
                    continue;
                }
                writer.println(i + ",name" + i);
            }
        }
        return file;
    }
}

