/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.LongSupplier;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.unsafe.impl.batchimport.HeapSizeSanityChecker;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;

public class HeapSizeSanityCheckerTest {
    private final LongSupplier freeMemorySupplier = (LongSupplier)Mockito.mock(LongSupplier.class);
    private final LongSupplier actualHeapSizeSupplier = (LongSupplier)Mockito.mock(LongSupplier.class);
    private final ImportLogic.Monitor monitor = (ImportLogic.Monitor)Mockito.mock(ImportLogic.Monitor.class);
    private final HeapSizeSanityChecker checker = new HeapSizeSanityChecker(this.monitor, this.freeMemorySupplier, this.actualHeapSizeSupplier);
    private final LongSupplier baseMemorySupplier = (LongSupplier)Mockito.mock(LongSupplier.class);
    private final MemoryStatsVisitor.Visitable baseMemory = visitor -> visitor.offHeapUsage(this.baseMemorySupplier.getAsLong());
    private final LongSupplier memoryUser1Supplier = (LongSupplier)Mockito.mock(LongSupplier.class);
    private final MemoryStatsVisitor.Visitable memoryUser1 = visitor -> visitor.offHeapUsage(this.memoryUser1Supplier.getAsLong());
    private final LongSupplier memoryUser2Supplier = (LongSupplier)Mockito.mock(LongSupplier.class);
    private final MemoryStatsVisitor.Visitable memoryUser2 = visitor -> visitor.offHeapUsage(this.memoryUser2Supplier.getAsLong());

    @Test
    public void shouldReportInsufficientAvailableMemory() {
        Mockito.when((Object)this.freeMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)2L));
        Mockito.when((Object)this.actualHeapSizeSupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.baseMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser1Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser2Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Input.Estimates estimates = Inputs.knownEstimates((long)1000000000L, (long)10000000000L, (long)2000000000L, (long)0L, (long)ByteUnit.gibiBytes((long)50L), (long)ByteUnit.gibiBytes((long)100L), (long)0L);
        this.checker.sanityCheck(estimates, Standard.LATEST_RECORD_FORMATS, this.baseMemory, new MemoryStatsVisitor.Visitable[]{this.memoryUser1, this.memoryUser2});
        ((ImportLogic.Monitor)Mockito.verify((Object)this.monitor)).insufficientAvailableMemory(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.monitor});
    }

    @Test
    public void shouldReportInsufficientHeapSize() {
        Mockito.when((Object)this.freeMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)20L));
        Mockito.when((Object)this.actualHeapSizeSupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.baseMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser1Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser2Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Input.Estimates estimates = Inputs.knownEstimates((long)1000000000L, (long)10000000000L, (long)2000000000L, (long)0L, (long)ByteUnit.gibiBytes((long)50L), (long)ByteUnit.gibiBytes((long)100L), (long)0L);
        this.checker.sanityCheck(estimates, Standard.LATEST_RECORD_FORMATS, this.baseMemory, new MemoryStatsVisitor.Visitable[]{this.memoryUser1, this.memoryUser2});
        ((ImportLogic.Monitor)Mockito.verify((Object)this.monitor)).insufficientHeapSize(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.monitor});
    }

    @Test
    public void shouldReportAbundantHeapSize() {
        Mockito.when((Object)this.freeMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)2L));
        Mockito.when((Object)this.actualHeapSizeSupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)20L));
        Mockito.when((Object)this.baseMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser1Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser2Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Input.Estimates estimates = Inputs.knownEstimates((long)1000000000L, (long)10000000000L, (long)2000000000L, (long)0L, (long)ByteUnit.gibiBytes((long)50L), (long)ByteUnit.gibiBytes((long)100L), (long)0L);
        this.checker.sanityCheck(estimates, Standard.LATEST_RECORD_FORMATS, this.baseMemory, new MemoryStatsVisitor.Visitable[]{this.memoryUser1, this.memoryUser2});
        ((ImportLogic.Monitor)Mockito.verify((Object)this.monitor)).abundantHeapSize(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.monitor});
    }

    @Test
    public void shouldReportNothingOnGoodSetup() {
        Mockito.when((Object)this.freeMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)10L));
        Mockito.when((Object)this.baseMemorySupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser1Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.memoryUser2Supplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)1L));
        Mockito.when((Object)this.actualHeapSizeSupplier.getAsLong()).thenReturn((Object)ByteUnit.gibiBytes((long)2L));
        Input.Estimates estimates = Inputs.knownEstimates((long)1000000000L, (long)10000000000L, (long)2000000000L, (long)0L, (long)ByteUnit.gibiBytes((long)50L), (long)ByteUnit.gibiBytes((long)100L), (long)0L);
        this.checker.sanityCheck(estimates, Standard.LATEST_RECORD_FORMATS, this.baseMemory, new MemoryStatsVisitor.Visitable[]{this.memoryUser1, this.memoryUser2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.monitor});
    }
}

