/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.unsafe.batchinsert.internal.FileSystemClosingBatchInserter;

public class BatchInsertersTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();

    @Test
    public void automaticallyCloseCreatedFileSystemOnShutdown() throws Exception {
        this.verifyInserterFileSystemClose(BatchInserters.inserter((File)this.getStoreDir()));
        this.verifyInserterFileSystemClose(BatchInserters.inserter((File)this.getStoreDir(), this.getConfig()));
        this.verifyInserterFileSystemClose(BatchInserters.inserter((File)this.getStoreDir(), this.getConfig(), this.getKernelExtensions()));
    }

    @Test
    public void providedFileSystemNotClosedAfterShutdown() throws IOException {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        this.vefiryProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)fs), fs);
        this.vefiryProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)fs, this.getConfig()), fs);
        this.vefiryProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)fs, this.getConfig(), this.getKernelExtensions()), fs);
    }

    private Iterable<KernelExtensionFactory<?>> getKernelExtensions() {
        return Iterables.asIterable((Object[])new KernelExtensionFactory[]{new InMemoryIndexProviderFactory()});
    }

    private Map<String, String> getConfig() {
        return MapUtil.stringMap((String[])new String[0]);
    }

    private void vefiryProvidedFileSystemOpenAfterShutdown(BatchInserter inserter, EphemeralFileSystemAbstraction fileSystemAbstraction) {
        inserter.shutdown();
        Assert.assertFalse((boolean)fileSystemAbstraction.isClosed());
    }

    private File getStoreDir() {
        return this.testDirectory.graphDbDir();
    }

    private void verifyInserterFileSystemClose(BatchInserter inserter) {
        Assert.assertThat((String)"Expect specific implementation that will do required cleanups.", (Object)inserter, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(FileSystemClosingBatchInserter.class)));
        inserter.shutdown();
    }
}

