/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.dump;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.dump.DumpProcessInformation;
import org.neo4j.test.rule.dump.DumpableProcess;

public class DumpProcessInformationTest {
    private static final String SIGNAL = "here";
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Before
    public void checkEnvironment() {
        Assume.assumeTrue((boolean)this.commandExists("jps"));
        Assume.assumeTrue((boolean)this.commandExists("jstack -h"));
    }

    private boolean commandExists(String command) {
        try {
            return Runtime.getRuntime().exec(command).waitFor() == 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Test
    public void shouldDumpProcessInformation() throws Exception {
        File directory = this.testDirectory.directory("dump");
        String java = ProcessUtil.getJavaExecutable().toString();
        Process process = Runtime.getRuntime().exec(new String[]{java, "-cp", ProcessUtil.getClassPath(), DumpableProcess.class.getName(), SIGNAL});
        this.awaitSignal(process);
        DumpProcessInformation dumper = new DumpProcessInformation((LogProvider)NullLogProvider.getInstance(), directory);
        Collection<Pair<Long, String>> pids = dumper.getJPids((Matcher<String>)Matchers.containsString((String)DumpableProcess.class.getSimpleName()));
        Assume.assumeThat((Object)pids.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Pair pid = (Pair)Iterables.single(pids);
        File threaddumpFile = dumper.doThreadDump((Pair<Long, String>)pid);
        process.destroy();
        Assert.assertTrue((boolean)this.fileContains(threaddumpFile, "traceableMethod", DumpableProcess.class.getName()));
    }

    private boolean fileContains(File file, String ... expectedStrings) throws IOException {
        Set expectedStringSet = Iterators.asSet((Object[])expectedStrings);
        try (Stream<String> lines = Files.lines(file.toPath());){
            lines.forEach(line -> expectedStringSet.removeIf(line::contains));
        }
        return expectedStringSet.isEmpty();
    }

    private void awaitSignal(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            if (!SIGNAL.equals(line)) {
                Assert.fail((String)("Got weird signal " + line));
            }
        }
    }
}

