/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;

public class EphemeralIdGenerator
implements IdGenerator {
    private final AtomicLong nextId = new AtomicLong();
    private final IdType idType;
    private final Queue<Long> freeList;
    private final AtomicInteger freedButNotReturnableIdCount = new AtomicInteger();

    public EphemeralIdGenerator(IdType idType, IdTypeConfiguration idTypeConfiguration) {
        this.idType = idType;
        this.freeList = idType != null && idTypeConfiguration.allowAggressiveReuse() ? new ConcurrentLinkedQueue() : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.idType + "]";
    }

    public synchronized long nextId() {
        Long id;
        if (this.freeList != null && (id = this.freeList.poll()) != null) {
            return id;
        }
        return this.nextId.getAndIncrement();
    }

    public synchronized IdRange nextIdBatch(int size) {
        long[] defragIds = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        if (this.freeList != null && !this.freeList.isEmpty()) {
            defragIds = new long[Integer.min(size, this.freeList.size())];
            for (int i = 0; i < defragIds.length; ++i) {
                defragIds[i] = this.freeList.poll();
            }
            size -= defragIds.length;
        }
        return new IdRange(defragIds, this.nextId.getAndAdd(size), size);
    }

    public void setHighId(long id) {
        this.nextId.set(id);
    }

    public long getHighId() {
        return this.nextId.get();
    }

    public void freeId(long id) {
        if (this.freeList != null) {
            this.freeList.add(id);
        } else {
            this.freedButNotReturnableIdCount.getAndIncrement();
        }
    }

    public void close() {
    }

    public long getNumberOfIdsInUse() {
        long result = this.freeList == null ? this.nextId.get() : this.nextId.get() - (long)this.freeList.size();
        return result - (long)this.freedButNotReturnableIdCount.get();
    }

    public long getDefragCount() {
        return 0L;
    }

    public void delete() {
    }

    public long getHighestPossibleIdInUse() {
        return this.nextId.get();
    }

    public static class Factory
    implements IdGeneratorFactory {
        protected final Map<IdType, IdGenerator> generators = new EnumMap<IdType, IdGenerator>(IdType.class);
        private final IdTypeConfigurationProvider idTypeConfigurationProvider = new CommunityIdTypeConfigurationProvider();

        public IdGenerator open(File filename, IdType idType, LongSupplier highId, long maxId) {
            return this.open(filename, 0, idType, highId, maxId);
        }

        public IdGenerator open(File fileName, int grabSize, IdType idType, LongSupplier highId, long maxId) {
            IdGenerator generator = this.generators.get(idType);
            if (generator == null) {
                IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
                generator = new EphemeralIdGenerator(idType, idTypeConfiguration);
                this.generators.put(idType, generator);
            }
            return generator;
        }

        public void create(File fileName, long highId, boolean throwIfFileExists) {
        }

        public IdGenerator get(IdType idType) {
            return this.generators.get(idType);
        }
    }
}

