/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.impl.util.collection.OffHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.PrimitiveLongDiffSets;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;

public class OffHeapCollectionsFactoryTest {
    private MemoryAllocationTracker memoryTracker;
    private OffHeapCollectionsFactory factory;

    @Before
    public void setUp() throws Exception {
        this.memoryTracker = (MemoryAllocationTracker)Mockito.spy((Object)new LocalMemoryTracker());
        this.factory = new OffHeapCollectionsFactory(this.memoryTracker);
    }

    @Test
    public void longSetAllocationAndRelease() {
        long mem0 = this.memoryTracker.usedDirectMemory();
        PrimitiveLongSet set = this.factory.newLongSet();
        long mem1 = this.memoryTracker.usedDirectMemory();
        Assert.assertNotEquals((long)mem0, (long)mem1);
        set.close();
        Assert.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory());
        ((MemoryAllocationTracker)Mockito.verify((Object)this.memoryTracker)).allocated(ArgumentMatchers.anyLong());
        ((MemoryAllocationTracker)Mockito.verify((Object)this.memoryTracker)).deallocated(ArgumentMatchers.anyLong());
    }

    @Test
    public void longDiffSetsAllocationAndRelease() {
        long mem0 = this.memoryTracker.usedDirectMemory();
        PrimitiveLongDiffSets diffSets = this.factory.newLongDiffSets();
        diffSets.add(1L);
        diffSets.remove(2L);
        long mem1 = this.memoryTracker.usedDirectMemory();
        Assert.assertNotEquals((long)mem0, (long)mem1);
        diffSets.close();
        Assert.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory());
        ((MemoryAllocationTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)2))).allocated(ArgumentMatchers.anyLong());
        ((MemoryAllocationTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)2))).deallocated(ArgumentMatchers.anyLong());
    }

    @Test
    public void longObjectMapAllocationAndRelease() {
        long mem0 = this.memoryTracker.usedDirectMemory();
        PrimitiveLongObjectMap map = this.factory.newLongObjectMap();
        map.put(1L, (Object)"foo");
        long mem1 = this.memoryTracker.usedDirectMemory();
        Assert.assertEquals((String)"update the test after switching to off-heap map", (long)mem0, (long)mem1);
    }

    @Test
    public void intObjectMapAllocationAndRelease() {
        long mem0 = this.memoryTracker.usedDirectMemory();
        PrimitiveIntObjectMap map = this.factory.newIntObjectMap();
        map.put(1, (Object)"foo");
        long mem1 = this.memoryTracker.usedDirectMemory();
        Assert.assertEquals((String)"update the test after switching to off-heap map", (long)mem0, (long)mem1);
    }
}

