/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.string.UTF8;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class RecordStoreConsistentReadTest<R extends AbstractBaseRecord, S extends RecordStore<R>> {
    protected static final int ID = 1;
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withInconsistentReads(false));
    private FileSystemAbstraction fs;
    private AtomicBoolean nextReadIsInconsistent;

    @Before
    public void setUp() {
        this.fs = new EphemeralFileSystemAbstraction();
        this.nextReadIsInconsistent = new AtomicBoolean();
    }

    @After
    public void tearDown() throws Exception {
        this.fs.close();
    }

    private NeoStores storeFixture() {
        PageCache pageCache = pageCacheRule.getPageCache(this.fs, PageCacheRule.config().withInconsistentReads(this.nextReadIsInconsistent));
        File storeDir = new File("stores");
        StoreFactory factory = new StoreFactory(storeDir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = factory.openAllNeoStores(true);
        S store = this.initialiseStore(neoStores);
        CommonAbstractStore commonAbstractStore = (CommonAbstractStore)store;
        commonAbstractStore.rebuildIdGenerator();
        return neoStores;
    }

    protected S initialiseStore(NeoStores neoStores) {
        S store = this.getStore(neoStores);
        store.updateRecord(this.createExistingRecord(false));
        return store;
    }

    protected abstract S getStore(NeoStores var1);

    protected abstract R createNullRecord(long var1);

    protected abstract R createExistingRecord(boolean var1);

    protected abstract R getLight(long var1, S var3);

    protected abstract void assertRecordsEqual(R var1, R var2);

    protected R getHeavy(S store, int id) {
        AbstractBaseRecord record = store.getRecord((long)id, store.newRecord(), RecordLoad.NORMAL);
        store.ensureHeavy(record);
        return (R)record;
    }

    protected R getForce(S store, int id) {
        return (R)store.getRecord((long)id, store.newRecord(), RecordLoad.FORCE);
    }

    @Test
    public void mustReadExistingRecord() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            R record = this.getHeavy(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(false));
        }
    }

    @Test
    public void mustReadExistingLightRecord() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            R record = this.getLight(1L, store);
            this.assertRecordsEqual(record, this.createExistingRecord(true));
        }
    }

    @Test
    public void mustForceReadExistingRecord() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            R record = this.getForce(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(true));
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void readingNonExistingRecordMustThrow() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            this.getHeavy(store, 2);
        }
    }

    @Test
    public void forceReadingNonExistingRecordMustReturnEmptyRecordWithThatId() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            R record = this.getForce(store, 2);
            R nullRecord = this.createNullRecord(2L);
            this.assertRecordsEqual(record, nullRecord);
        }
    }

    @Test
    public void mustRetryInconsistentReads() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            this.nextReadIsInconsistent.set(true);
            R record = this.getHeavy(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(false));
        }
    }

    @Test
    public void mustRetryInconsistentLightReads() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            this.nextReadIsInconsistent.set(true);
            R record = this.getLight(1L, store);
            this.assertRecordsEqual(record, this.createExistingRecord(true));
        }
    }

    @Test
    public void mustRetryInconsistentForcedReads() {
        try (NeoStores neoStores = this.storeFixture();){
            S store = this.getStore(neoStores);
            this.nextReadIsInconsistent.set(true);
            R record = this.getForce(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(true));
        }
    }

    public static class PropertyStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<PropertyRecord, PropertyStore> {
        @Override
        protected PropertyStore getStore(NeoStores neoStores) {
            return neoStores.getPropertyStore();
        }

        @Override
        protected PropertyRecord createNullRecord(long id) {
            PropertyRecord record = new PropertyRecord(id);
            record.setNextProp(0L);
            record.setPrevProp(0L);
            return record;
        }

        @Override
        protected PropertyRecord createExistingRecord(boolean light) {
            PropertyRecord record = new PropertyRecord(1L);
            record.setId(1L);
            record.setNextProp(2L);
            record.setPrevProp(4L);
            record.setInUse(true);
            PropertyBlock block = new PropertyBlock();
            ReusableRecordsAllocator stringAllocator = new ReusableRecordsAllocator(64, new DynamicRecord[]{new DynamicRecord(7L)});
            Value value = Values.of((Object)"a string too large to fit in the property block itself");
            PropertyStore.encodeValue((PropertyBlock)block, (int)6, (Value)value, (DynamicRecordAllocator)stringAllocator, null, (boolean)true);
            if (light) {
                block.getValueRecords().clear();
            }
            record.setPropertyBlock(block);
            return record;
        }

        @Override
        protected PropertyRecord getLight(long id, PropertyStore store) {
            throw new AssumptionViolatedException("Getting a light non-existing property record will throw.");
        }

        @Override
        protected PropertyRecord getHeavy(PropertyStore store, int id) {
            PropertyRecord record = (PropertyRecord)super.getHeavy(store, id);
            this.ensureHeavy(store, record);
            return record;
        }

        private void ensureHeavy(PropertyStore store, PropertyRecord record) {
            for (PropertyBlock propertyBlock : record) {
                store.ensureHeavy(propertyBlock);
            }
        }

        @Override
        protected void assertRecordsEqual(PropertyRecord actualRecord, PropertyRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getDeletedRecords", (Object)actualRecord.getDeletedRecords(), (Matcher)Matchers.is((Object)expectedRecord.getDeletedRecords()));
            Assert.assertThat((String)"getNextProp", (Object)actualRecord.getNextProp(), (Matcher)Matchers.is((Object)expectedRecord.getNextProp()));
            Assert.assertThat((String)"getEntityId", (Object)actualRecord.getNodeId(), (Matcher)Matchers.is((Object)expectedRecord.getNodeId()));
            Assert.assertThat((String)"getPrevProp", (Object)actualRecord.getPrevProp(), (Matcher)Matchers.is((Object)expectedRecord.getPrevProp()));
            Assert.assertThat((String)"getRelId", (Object)actualRecord.getRelId(), (Matcher)Matchers.is((Object)expectedRecord.getRelId()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            List actualBlocks = Iterables.asList((Iterable)actualRecord);
            List expectedBlocks = Iterables.asList((Iterable)expectedRecord);
            Assert.assertThat((String)"getPropertyBlocks().size", (Object)actualBlocks.size(), (Matcher)Matchers.is((Object)expectedBlocks.size()));
            for (int i = 0; i < actualBlocks.size(); ++i) {
                PropertyBlock actualBlock = (PropertyBlock)actualBlocks.get(i);
                PropertyBlock expectedBlock = (PropertyBlock)expectedBlocks.get(i);
                this.assertPropertyBlocksEqual(i, actualBlock, expectedBlock);
            }
        }

        private void assertPropertyBlocksEqual(int index, PropertyBlock actualBlock, PropertyBlock expectedBlock) {
            Assert.assertThat((String)("[" + index + "]getKeyIndexId"), (Object)actualBlock.getKeyIndexId(), (Matcher)Matchers.is((Object)expectedBlock.getKeyIndexId()));
            Assert.assertThat((String)("[" + index + "]getSingleValueBlock"), (Object)actualBlock.getSingleValueBlock(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueBlock()));
            Assert.assertThat((String)("[" + index + "]getSingleValueByte"), (Object)actualBlock.getSingleValueByte(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueByte()));
            Assert.assertThat((String)("[" + index + "]getSingleValueInt"), (Object)actualBlock.getSingleValueInt(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueInt()));
            Assert.assertThat((String)("[" + index + "]getSingleValueLong"), (Object)actualBlock.getSingleValueLong(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueLong()));
            Assert.assertThat((String)("[" + index + "]getSingleValueShort"), (Object)actualBlock.getSingleValueShort(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueShort()));
            Assert.assertThat((String)("[" + index + "]getSize"), (Object)actualBlock.getSize(), (Matcher)Matchers.is((Object)expectedBlock.getSize()));
            Assert.assertThat((String)("[" + index + "]getType"), (Object)actualBlock.getType(), (Matcher)Matchers.is((Object)expectedBlock.getType()));
            Assert.assertThat((String)("[" + index + "]isLight"), (Object)actualBlock.isLight(), (Matcher)Matchers.is((Object)expectedBlock.isLight()));
            List actualValueRecords = actualBlock.getValueRecords();
            List expectedValueRecords = expectedBlock.getValueRecords();
            Assert.assertThat((String)("[" + index + "]getValueRecords.size"), (Object)actualValueRecords.size(), (Matcher)Matchers.is((Object)expectedValueRecords.size()));
            for (int i = 0; i < actualValueRecords.size(); ++i) {
                DynamicRecord actualValueRecord = (DynamicRecord)actualValueRecords.get(i);
                DynamicRecord expectedValueRecord = (DynamicRecord)expectedValueRecords.get(i);
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getData"), (Object)actualValueRecord.getData(), (Matcher)Matchers.is((Object)expectedValueRecord.getData()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getLength"), (Object)actualValueRecord.getLength(), (Matcher)Matchers.is((Object)expectedValueRecord.getLength()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getNextBlock"), (Object)actualValueRecord.getNextBlock(), (Matcher)Matchers.is((Object)expectedValueRecord.getNextBlock()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getType"), (Object)actualValueRecord.getType(), (Matcher)Matchers.is((Object)expectedValueRecord.getType()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getId"), (Object)actualValueRecord.getId(), (Matcher)Matchers.is((Object)expectedValueRecord.getId()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getLongId"), (Object)actualValueRecord.getId(), (Matcher)Matchers.is((Object)expectedValueRecord.getId()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]isStartRecord"), (Object)actualValueRecord.isStartRecord(), (Matcher)Matchers.is((Object)expectedValueRecord.isStartRecord()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]inUse"), (Object)actualValueRecord.inUse(), (Matcher)Matchers.is((Object)expectedValueRecord.inUse()));
            }
        }
    }

    public static class SchemaStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<DynamicRecord, SchemaStore> {
        private static final byte[] EXISTING_RECORD_DATA = "Random bytes".getBytes();

        @Override
        protected SchemaStore getStore(NeoStores neoStores) {
            return neoStores.getSchemaStore();
        }

        @Override
        protected DynamicRecord createNullRecord(long id) {
            DynamicRecord record = new DynamicRecord(id);
            record.setNextBlock(0L);
            record.setData(new byte[0]);
            return record;
        }

        @Override
        protected DynamicRecord createExistingRecord(boolean light) {
            DynamicRecord record = new DynamicRecord(1L);
            record.setInUse(true);
            record.setStartRecord(true);
            record.setLength(EXISTING_RECORD_DATA.length);
            record.setData(EXISTING_RECORD_DATA);
            return record;
        }

        @Override
        protected DynamicRecord getLight(long id, SchemaStore store) {
            throw new AssumptionViolatedException("Light loading of DynamicRecords is a little different");
        }

        @Override
        protected void assertRecordsEqual(DynamicRecord actualRecord, DynamicRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getData", (Object)actualRecord.getData(), (Matcher)Matchers.is((Object)expectedRecord.getData()));
            Assert.assertThat((String)"getLength", (Object)actualRecord.getLength(), (Matcher)Matchers.is((Object)expectedRecord.getLength()));
            Assert.assertThat((String)"getNextBlock", (Object)actualRecord.getNextBlock(), (Matcher)Matchers.is((Object)expectedRecord.getNextBlock()));
            Assert.assertThat((String)"getType", (Object)actualRecord.getType(), (Matcher)Matchers.is((Object)expectedRecord.getType()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"isStartRecord", (Object)actualRecord.isStartRecord(), (Matcher)Matchers.is((Object)expectedRecord.isStartRecord()));
        }
    }

    public static class LabelTokenStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<LabelTokenRecord, LabelTokenStore> {
        private static final int NAME_RECORD_ID = 2;
        private static final byte[] NAME_RECORD_DATA = UTF8.encode((String)"TheLabel");

        @Override
        protected LabelTokenStore getStore(NeoStores neoStores) {
            return neoStores.getLabelTokenStore();
        }

        @Override
        protected LabelTokenStore initialiseStore(NeoStores neoStores) {
            LabelTokenStore store = this.getStore(neoStores);
            LabelTokenRecord record = this.createExistingRecord(false);
            DynamicRecord nameRecord = new DynamicRecord(2L);
            record.getNameRecords().clear();
            nameRecord.setData(NAME_RECORD_DATA);
            nameRecord.setInUse(true);
            record.addNameRecord(nameRecord);
            store.updateRecord((TokenRecord)record);
            return store;
        }

        @Override
        protected LabelTokenRecord createNullRecord(long id) {
            return new LabelTokenRecord((int)id).initialize(false, 0);
        }

        @Override
        protected LabelTokenRecord createExistingRecord(boolean light) {
            LabelTokenRecord record = new LabelTokenRecord(1);
            record.setNameId(2);
            record.setInUse(true);
            if (!light) {
                DynamicRecord nameRecord = new DynamicRecord(2L);
                nameRecord.setInUse(true);
                nameRecord.setData(NAME_RECORD_DATA);
                record.addNameRecord(nameRecord);
            }
            return record;
        }

        @Override
        protected LabelTokenRecord getLight(long id, LabelTokenStore store) {
            throw new AssumptionViolatedException("No light loading of LabelTokenRecords");
        }

        @Override
        protected void assertRecordsEqual(LabelTokenRecord actualRecord, LabelTokenRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getNameId", (Object)actualRecord.getNameId(), (Matcher)Matchers.is((Object)expectedRecord.getNameId()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"isLight", (Object)actualRecord.isLight(), (Matcher)Matchers.is((Object)expectedRecord.isLight()));
            Collection actualNameRecords = actualRecord.getNameRecords();
            Collection expectedNameRecords = expectedRecord.getNameRecords();
            Assert.assertThat((String)"getNameRecords.size", (Object)actualNameRecords.size(), (Matcher)Matchers.is((Object)expectedNameRecords.size()));
            Iterator actualNRs = actualNameRecords.iterator();
            Iterator expectedNRs = expectedNameRecords.iterator();
            int i = 0;
            while (actualNRs.hasNext() && expectedNRs.hasNext()) {
                DynamicRecord actualNameRecord = (DynamicRecord)actualNRs.next();
                DynamicRecord expectedNameRecord = (DynamicRecord)expectedNRs.next();
                Assert.assertThat((String)("[" + i + "]getData"), (Object)actualNameRecord.getData(), (Matcher)Matchers.is((Object)expectedNameRecord.getData()));
                Assert.assertThat((String)("[" + i + "]getLength"), (Object)actualNameRecord.getLength(), (Matcher)Matchers.is((Object)expectedNameRecord.getLength()));
                Assert.assertThat((String)("[" + i + "]getNextBlock"), (Object)actualNameRecord.getNextBlock(), (Matcher)Matchers.is((Object)expectedNameRecord.getNextBlock()));
                Assert.assertThat((String)("[" + i + "]getType"), (Object)actualNameRecord.getType(), (Matcher)Matchers.is((Object)expectedNameRecord.getType()));
                Assert.assertThat((String)("[" + i + "]getId"), (Object)actualNameRecord.getId(), (Matcher)Matchers.is((Object)expectedNameRecord.getId()));
                Assert.assertThat((String)("[" + i + "]getLongId"), (Object)actualNameRecord.getId(), (Matcher)Matchers.is((Object)expectedNameRecord.getId()));
                Assert.assertThat((String)("[" + i + "]isStartRecord"), (Object)actualNameRecord.isStartRecord(), (Matcher)Matchers.is((Object)expectedNameRecord.isStartRecord()));
                Assert.assertThat((String)("[" + i + "]inUse"), (Object)actualNameRecord.inUse(), (Matcher)Matchers.is((Object)expectedNameRecord.inUse()));
                ++i;
            }
        }
    }

    public static class RelationshipStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<RelationshipRecord, RelationshipStore> {
        private static final int FIRST_NODE = 2;
        private static final int SECOND_NODE = 3;
        private static final int TYPE = 4;
        private static final int FIRST_PREV_REL = 5;
        private static final int FIRST_NEXT_REL = 6;
        private static final int SECOND_PREV_REL = 7;
        private static final int SECOND_NEXT_REL = 8;

        @Override
        protected RelationshipRecord createNullRecord(long id) {
            RelationshipRecord record = new RelationshipRecord(id, false, 0L, 0L, 0, 0L, 0L, 0L, 0L, false, false);
            record.setNextProp(0L);
            return record;
        }

        @Override
        protected RelationshipRecord createExistingRecord(boolean light) {
            return new RelationshipRecord(1L, true, 2L, 3L, 4, 5L, 6L, 7L, 8L, true, true);
        }

        @Override
        protected RelationshipRecord getLight(long id, RelationshipStore store) {
            return (RelationshipRecord)store.getRecord(id, store.newRecord(), RecordLoad.NORMAL);
        }

        @Override
        protected void assertRecordsEqual(RelationshipRecord actualRecord, RelationshipRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getFirstNextRel", (Object)actualRecord.getFirstNextRel(), (Matcher)Matchers.is((Object)expectedRecord.getFirstNextRel()));
            Assert.assertThat((String)"getFirstNode", (Object)actualRecord.getFirstNode(), (Matcher)Matchers.is((Object)expectedRecord.getFirstNode()));
            Assert.assertThat((String)"getFirstPrevRel", (Object)actualRecord.getFirstPrevRel(), (Matcher)Matchers.is((Object)expectedRecord.getFirstPrevRel()));
            Assert.assertThat((String)"getSecondNextRel", (Object)actualRecord.getSecondNextRel(), (Matcher)Matchers.is((Object)expectedRecord.getSecondNextRel()));
            Assert.assertThat((String)"getSecondNode", (Object)actualRecord.getSecondNode(), (Matcher)Matchers.is((Object)expectedRecord.getSecondNode()));
            Assert.assertThat((String)"getSecondPrevRel", (Object)actualRecord.getSecondPrevRel(), (Matcher)Matchers.is((Object)expectedRecord.getSecondPrevRel()));
            Assert.assertThat((String)"getType", (Object)actualRecord.getType(), (Matcher)Matchers.is((Object)expectedRecord.getType()));
            Assert.assertThat((String)"isFirstInFirstChain", (Object)actualRecord.isFirstInFirstChain(), (Matcher)Matchers.is((Object)expectedRecord.isFirstInFirstChain()));
            Assert.assertThat((String)"isFirstInSecondChain", (Object)actualRecord.isFirstInSecondChain(), (Matcher)Matchers.is((Object)expectedRecord.isFirstInSecondChain()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getNextProp", (Object)actualRecord.getNextProp(), (Matcher)Matchers.is((Object)expectedRecord.getNextProp()));
            Assert.assertThat((String)"inUse", (Object)actualRecord.inUse(), (Matcher)Matchers.is((Object)expectedRecord.inUse()));
        }

        @Override
        protected RelationshipStore getStore(NeoStores neoStores) {
            return neoStores.getRelationshipStore();
        }
    }
}

