/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.time.Clock;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class AcquisitionTimeoutCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    private final long TEST_TIMEOUT_SECONDS = 30L;
    private FakeClock clock;
    private Config customConfig;
    private Locks lockManager;
    private Locks.Client client;
    private Locks.Client client2;
    @Rule
    public VerboseTimeout timeout = VerboseTimeout.builder().withTimeout(30L, TimeUnit.SECONDS).build();

    public AcquisitionTimeoutCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Before
    public void setUp() {
        this.customConfig = Config.defaults((Setting)GraphDatabaseSettings.lock_acquisition_timeout, (String)"100ms");
        this.clock = Clocks.fakeClock((long)100000L, (TimeUnit)TimeUnit.MINUTES);
        this.lockManager = this.suite.createLockManager(this.customConfig, (Clock)this.clock);
        this.client = this.lockManager.newClient();
        this.client2 = this.lockManager.newClient();
    }

    @After
    public void tearDown() {
        this.client2.close();
        this.client.close();
        this.lockManager.close();
    }

    @Test
    public void terminateSharedLockAcquisition() throws InterruptedException {
        this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future sharedLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertThat((Object)this.threadB, (Matcher)OtherThreadRule.isWaiting());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(sharedLockAcquisition);
    }

    @Test
    public void terminateExclusiveLockAcquisitionForExclusivelyLockedResource() throws InterruptedException {
        this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future exclusiveLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertThat((Object)this.threadB, (Matcher)OtherThreadRule.isWaiting());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    @Test
    public void terminateExclusiveLockAcquisitionForSharedLockedResource() throws InterruptedException {
        this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future exclusiveLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertThat((Object)this.threadB, (Matcher)OtherThreadRule.isWaiting());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    @Test
    public void terminateExclusiveLockAcquisitionForSharedLockedResourceWithSharedLockHeld() throws InterruptedException {
        this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client2.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future exclusiveLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertThat((Object)this.threadB, (Matcher)OtherThreadRule.isWaiting());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    private void verifyAcquisitionFailure(Future<Boolean> lockAcquisition) throws InterruptedException {
        try {
            lockAcquisition.get();
            Assert.fail((String)"Lock acquisition should fail.");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)CoreMatchers.instanceOf(LockAcquisitionTimeoutException.class));
        }
    }
}

