/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.values.storable.Values;

public abstract class NativeSchemaIndexPopulatorTest<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeSchemaIndexTestUtil<KEY, VALUE> {
    private static final int LARGE_AMOUNT_OF_UPDATES = 1000;
    static final PropertyAccessor null_property_accessor = (nodeId, propKeyId) -> {
        throw new RuntimeException("Did not expect an attempt to go to store");
    };
    NativeSchemaIndexPopulator<KEY, VALUE> populator;

    @Before
    public void setupPopulator() throws IOException {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        this.populator = this.createPopulator(samplingConfig);
    }

    abstract NativeSchemaIndexPopulator<KEY, VALUE> createPopulator(IndexSamplingConfig var1) throws IOException;

    @Test
    public void createShouldCreateFile() throws Exception {
        this.assertFileNotPresent();
        this.populator.create();
        this.assertFilePresent();
        this.populator.close(true);
    }

    @Test
    public void createShouldClearExistingFile() throws Exception {
        byte[] someBytes = this.fileWithContent();
        this.populator.create();
        try (StoreChannel r = this.fs.open(this.getIndexFile(), OpenMode.READ);){
            byte[] firstBytes = new byte[someBytes.length];
            r.readAll(ByteBuffer.wrap(firstBytes));
            Assert.assertNotEquals((String)"Expected previous file content to have been cleared but was still there", (Object)someBytes, (Object)firstBytes);
        }
        this.populator.close(true);
    }

    @Test
    public void dropShouldDeleteExistingFile() throws Exception {
        this.populator.create();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void dropShouldSucceedOnNonExistentFile() throws Exception {
        this.assertFileNotPresent();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void addShouldHandleEmptyCollection() throws Exception {
        this.populator.create();
        List updates = Collections.emptyList();
        this.populator.add(updates);
        this.populator.close(true);
    }

    @Test
    public void addShouldApplyAllUpdatesOnce() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.populator.add(Arrays.asList(updates));
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void updaterShouldApplyUpdates() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void updaterMustThrowIfProcessAfterClose() throws Exception {
        this.populator.create();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);
        updater.close();
        try {
            updater.process(this.layoutUtil.add(1L, Values.of((Object)Long.MAX_VALUE)));
            Assert.fail((String)"Expected process to throw on closed updater");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.populator.close(true);
    }

    @Test
    public void shouldApplyInterleavedUpdatesFromAddAndUpdater() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.applyInterleaved(updates, this.populator);
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void successfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assert.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(true);
        existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        Assert.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    public void successfulCloseMustMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(true);
        this.assertHeader(true, null, false);
    }

    @Test
    public void unsuccessfulCloseMustSucceedWithoutMarkAsFailed() throws Exception {
        this.populator.create();
        this.populator.close(false);
    }

    @Test
    public void unsuccessfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assert.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(false);
        existingMapping = this.pageCache.getExistingMapping(this.getIndexFile());
        Assert.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    public void unsuccessfulCloseMustNotMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(false);
        this.assertHeader(false, "", false);
    }

    @Test
    public void closeMustWriteFailureMessageAfterMarkedAsFailed() throws Exception {
        this.populator.create();
        String failureMessage = "Fly, you fools!";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false);
        this.assertHeader(false, failureMessage, false);
    }

    @Test
    public void closeMustWriteFailureMessageAfterMarkedAsFailedWithLongMessage() throws Exception {
        this.populator.create();
        String failureMessage = this.longString(this.pageCache.pageSize());
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false);
        this.assertHeader(false, failureMessage, true);
    }

    @Test
    public void successfulCloseMustThrowIfMarkedAsFailed() throws Exception {
        this.populator.create();
        this.populator.markAsFailed("");
        try {
            this.populator.close(true);
            Assert.fail((String)"Expected successful close to fail after markedAsFailed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.populator.close(false);
    }

    @Test
    public void shouldApplyLargeAmountOfInterleavedRandomUpdates() throws Exception {
        this.populator.create();
        this.random.reset();
        Random updaterRandom = new Random(this.random.seed());
        Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> updates = this.layoutUtil.randomUpdateGenerator(this.random);
        int count = this.interleaveLargeAmountOfUpdates(updaterRandom, updates);
        this.populator.close(true);
        this.random.reset();
        this.verifyUpdates(this.layoutUtil.randomUpdateGenerator(this.random), count);
    }

    @Test
    public void dropMustSucceedAfterSuccessfulClose() throws Exception {
        this.populator.create();
        this.populator.close(true);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void dropMustSucceedAfterUnsuccessfulClose() throws Exception {
        this.populator.create();
        this.populator.close(false);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void successfulCloseMustThrowWithoutPriorSuccessfulCreate() throws Exception {
        this.assertFileNotPresent();
        try {
            this.populator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void unsuccessfulCloseMustSucceedWithoutSuccessfulPriorCreate() throws Exception {
        this.assertFileNotPresent();
        String failureMessage = "There is no spoon";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false);
        this.assertHeader(false, failureMessage, false);
    }

    @Test
    public void successfulCloseMustThrowAfterDrop() throws Exception {
        this.populator.create();
        this.populator.drop();
        try {
            this.populator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void unsuccessfulCloseMustThrowAfterDrop() throws Exception {
        this.populator.create();
        this.populator.drop();
        try {
            this.populator.close(false);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private int interleaveLargeAmountOfUpdates(Random updaterRandom, Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> updates) throws IOException, IndexEntryConflictException {
        int count = 0;
        for (int i = 0; i < 1000; ++i) {
            if ((double)updaterRandom.nextFloat() < 0.1) {
                try (IndexUpdater indexUpdater = this.populator.newPopulatingUpdater(null_property_accessor);){
                    int numberOfUpdaterUpdates = updaterRandom.nextInt(100);
                    for (int j = 0; j < numberOfUpdaterUpdates; ++j) {
                        indexUpdater.process(updates.next());
                        ++count;
                    }
                }
            }
            this.populator.add(Collections.singletonList(updates.next()));
            ++count;
        }
        return count;
    }

    private void assertHeader(boolean online, String failureMessage, boolean messageTruncated) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        try (GBPTree ignored = new GBPTree(this.pageCache, this.getIndexFile(), this.layout, 0, GBPTree.NO_MONITOR, (Header.Reader)headerReader, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.IMMEDIATE);){
            if (online) {
                Assert.assertEquals((String)"Index was not marked as online when expected not to be.", (long)1L, (long)headerReader.state);
                Assert.assertNull((String)"Expected failure message to be null when marked as online.", (Object)headerReader.failureMessage);
            } else {
                Assert.assertEquals((String)"Index was marked as online when expected not to be.", (long)0L, (long)headerReader.state);
                if (messageTruncated) {
                    Assert.assertTrue((headerReader.failureMessage.length() < failureMessage.length() ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)failureMessage.startsWith(headerReader.failureMessage));
                } else {
                    Assert.assertEquals((Object)failureMessage, (Object)headerReader.failureMessage);
                }
            }
        }
    }

    private String longString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    private void applyInterleaved(IndexEntryUpdate<SchemaIndexDescriptor>[] updates, NativeSchemaIndexPopulator<KEY, VALUE> populator) throws IOException, IndexEntryConflictException {
        boolean useUpdater = true;
        ArrayList<IndexEntryUpdate<SchemaIndexDescriptor>> populatorBatch = new ArrayList<IndexEntryUpdate<SchemaIndexDescriptor>>();
        IndexUpdater updater = populator.newPopulatingUpdater(null_property_accessor);
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
            if (this.random.nextInt(100) < 20) {
                if (useUpdater) {
                    updater.close();
                    populatorBatch = new ArrayList();
                } else {
                    populator.add(populatorBatch);
                    updater = populator.newPopulatingUpdater(null_property_accessor);
                }
                boolean bl = useUpdater = !useUpdater;
            }
            if (useUpdater) {
                updater.process(update);
                continue;
            }
            populatorBatch.add(update);
        }
        if (useUpdater) {
            updater.close();
        } else {
            populator.add(populatorBatch);
        }
    }

    private void verifyUpdates(Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> indexEntryUpdateIterator, int count) throws IOException {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        for (int i = 0; i < count; ++i) {
            updates[i] = indexEntryUpdateIterator.next();
        }
        this.verifyUpdates(updates);
    }

    private byte[] fileWithContent() throws IOException {
        int size = 1000;
        this.fs.mkdirs(this.getIndexFile().getParentFile());
        try (StoreChannel storeChannel = this.fs.create(this.getIndexFile());){
            byte[] someBytes = new byte[size];
            this.random.nextBytes(someBytes);
            storeChannel.writeAll(ByteBuffer.wrap(someBytes));
            byte[] byArray = someBytes;
            return byArray;
        }
    }
}

