/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.index.labelscan.PhysicalToLogicalLabelChanges;

public class PhysicalToLogicalLabelChangesTest {
    @Test
    public void shouldSeeSimpleAddition() {
        this.convertAndAssert(this.ids(new long[0]), this.ids(2L), this.ids(new long[0]), this.ids(2L));
    }

    @Test
    public void shouldSeeSimpleRemoval() {
        this.convertAndAssert(this.ids(2L), this.ids(new long[0]), this.ids(2L), this.ids(new long[0]));
    }

    @Test
    public void shouldSeeSomeAdded() {
        this.convertAndAssert(this.ids(1L, 3L, 5L), this.ids(1L, 2L, 3L, 4L, 5L, 6L), this.ids(new long[0]), this.ids(2L, 4L, 6L));
    }

    @Test
    public void shouldSeeSomeRemoved() {
        this.convertAndAssert(this.ids(1L, 2L, 3L, 4L, 5L, 6L), this.ids(1L, 3L, 5L), this.ids(2L, 4L, 6L), this.ids(new long[0]));
    }

    @Test
    public void shouldSeeSomeAddedAndSomeRemoved() {
        this.convertAndAssert(this.ids(1L, 3L, 4L, 6L), this.ids(0L, 2L, 3L, 5L, 6L), this.ids(1L, 4L), this.ids(0L, 2L, 5L));
    }

    private void convertAndAssert(long[] before, long[] after, long[] expectedRemoved, long[] expectedAdded) {
        NodeLabelUpdate update = NodeLabelUpdate.labelChanges((long)0L, (long[])before, (long[])after);
        PhysicalToLogicalLabelChanges.convertToAdditionsAndRemovals((NodeLabelUpdate)update);
        Assert.assertArrayEquals((long[])this.terminate(update.getLabelsBefore()), (long[])expectedRemoved);
        Assert.assertArrayEquals((long[])this.terminate(update.getLabelsAfter()), (long[])expectedAdded);
    }

    private long[] terminate(long[] labels) {
        int length = this.actualLength(labels);
        return length == labels.length ? labels : Arrays.copyOf(labels, length);
    }

    private int actualLength(long[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] != -1L) continue;
            return i;
        }
        return labels.length;
    }

    private long[] ids(long ... ids) {
        return ids;
    }
}

