/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.index.labelscan.CompositeLabelScanValueIterator;

public class CompositeLabelScanValueIteratorTest {
    @Test
    public void mustHandleEmptyListOfIterators() {
        List iterators = Collections.emptyList();
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Expected iterator to throw");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void mustHandleEmptyIterator() {
        List<PrimitiveLongResourceIterator> iterators = Collections.singletonList(PrimitiveLongResourceCollections.emptyIterator());
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void mustHandleMultipleEmptyIterators() {
        List<PrimitiveLongResourceIterator> iterators = this.asMutableList(PrimitiveLongResourceCollections.emptyIterator(), PrimitiveLongResourceCollections.emptyIterator(), PrimitiveLongResourceCollections.emptyIterator());
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void mustReportAllFromSingleIterator() {
        long[] expected = new long[]{0L, 1L, Long.MAX_VALUE};
        List<PrimitiveLongResourceIterator> iterators = Collections.singletonList(PrimitiveLongResourceCollections.iterator(null, (long[])expected));
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
    }

    @Test
    public void mustReportAllFromNonOverlappingMultipleIterators() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[2];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        List<PrimitiveLongResourceIterator> iterators = this.asMutableList(primitiveLongResourceIteratorArray);
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        iterator.close();
        Assert.assertEquals((String)"expected close count", (long)2L, (long)closeCounter.get());
    }

    @Test
    public void mustReportUniqueValuesFromOverlappingIterators() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] thirdIter = new long[]{0L, 3L};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[3];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        List<PrimitiveLongResourceIterator> iterators = this.asMutableList(primitiveLongResourceIteratorArray);
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        iterator.close();
        Assert.assertEquals((String)"expected close count", (long)3L, (long)closeCounter.get());
    }

    @Test
    public void mustReportUniqueValuesFromOverlappingIteratorsWithOneEmpty() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] thirdIter = new long[]{0L, 3L};
        long[] fourthIter = new long[]{};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[4];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        primitiveLongResourceIteratorArray[3] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])fourthIter);
        List<PrimitiveLongResourceIterator> iterators = this.asMutableList(primitiveLongResourceIteratorArray);
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, false);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        iterator.close();
        Assert.assertEquals((String)"expected close count", (long)4L, (long)closeCounter.get());
    }

    @Test
    public void mustOnlyReportValuesReportedByAll() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, Long.MAX_VALUE};
        long[] secondIter = new long[]{0L, 1L, Long.MAX_VALUE};
        long[] thirdIter = new long[]{0L, 1L, 2L, Long.MAX_VALUE};
        long[] expected = new long[]{0L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[3];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        List<PrimitiveLongResourceIterator> iterators = this.asMutableList(primitiveLongResourceIteratorArray);
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, true);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        iterator.close();
        Assert.assertEquals((String)"expected close count", (long)3L, (long)closeCounter.get());
    }

    @Test
    public void mustOnlyReportValuesReportedByAllWithOneEmpty() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, Long.MAX_VALUE};
        long[] secondIter = new long[]{0L, 1L, Long.MAX_VALUE};
        long[] thirdIter = new long[]{0L, 1L, 2L, Long.MAX_VALUE};
        long[] fourthIter = new long[]{};
        long[] expected = new long[]{};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[4];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        primitiveLongResourceIteratorArray[3] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])fourthIter);
        List<PrimitiveLongResourceIterator> iterators = this.asMutableList(primitiveLongResourceIteratorArray);
        CompositeLabelScanValueIterator iterator = new CompositeLabelScanValueIterator(iterators, true);
        Assert.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        iterator.close();
        Assert.assertEquals((String)"expected close count", (long)4L, (long)closeCounter.get());
    }

    @SafeVarargs
    private final <T> List<T> asMutableList(T ... objects) {
        return new ArrayList<T>(Arrays.asList(objects));
    }
}

