/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.Race;

public class SchemaCacheTest {
    private final SchemaRule hans = this.newIndexRule(1L, 0, 5);
    private final SchemaRule witch = this.nodePropertyExistenceConstraintRule(2L, 3, 6);
    private final SchemaRule gretel = this.newIndexRule(3L, 0, 7);
    private final ConstraintRule robot = this.relPropertyExistenceConstraintRule(7L, 8, 9);

    @Test
    public void should_construct_schema_cache() {
        List<SchemaRule> rules = Arrays.asList(this.hans, this.witch, this.gretel, this.robot);
        SchemaCache cache = new SchemaCache((org.neo4j.kernel.impl.constraints.ConstraintSemantics)new ConstraintSemantics(), rules);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.indexRules()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.witch, this.robot}), (Object)Iterables.asSet((Iterable)cache.constraintRules()));
    }

    @Test
    public void addRemoveIndexes() {
        List<SchemaRule> rules = Arrays.asList(this.hans, this.witch, this.gretel, this.robot);
        SchemaCache cache = new SchemaCache((org.neo4j.kernel.impl.constraints.ConstraintSemantics)new ConstraintSemantics(), rules);
        IndexRule rule1 = this.newIndexRule(10L, 11, 12);
        IndexRule rule2 = this.newIndexRule(13L, 14, 15);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.removeSchemaRule(this.hans.getId());
        cache.removeSchemaRule(this.witch.getId());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.gretel, rule1, rule2}), (Object)Iterables.asSet((Iterable)cache.indexRules()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintRule[]{this.robot}), (Object)Iterables.asSet((Iterable)cache.constraintRules()));
    }

    @Test
    public void addSchemaRules() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule(this.hans);
        cache.addSchemaRule(this.gretel);
        cache.addSchemaRule(this.witch);
        cache.addSchemaRule((SchemaRule)this.robot);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.indexRules()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.witch, this.robot}), (Object)Iterables.asSet((Iterable)cache.constraintRules()));
    }

    @Test
    public void should_list_constraints() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)this.uniquenessConstraintRule(0L, 1, 2, 133L));
        cache.addSchemaRule((SchemaRule)this.uniquenessConstraintRule(1L, 3, 4, 133L));
        cache.addSchemaRule((SchemaRule)this.relPropertyExistenceConstraintRule(2L, 5, 6));
        cache.addSchemaRule((SchemaRule)this.nodePropertyExistenceConstraintRule(3L, 7, 8));
        UniquenessConstraintDescriptor unique1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{2});
        UniquenessConstraintDescriptor unique2 = ConstraintDescriptorFactory.uniqueForLabel((int)3, (int[])new int[]{4});
        RelExistenceConstraintDescriptor existsRel = ConstraintDescriptorFactory.existsForRelType((int)5, (int[])new int[]{6});
        NodeExistenceConstraintDescriptor existsNode = ConstraintDescriptorFactory.existsForLabel((int)7, (int[])new int[]{8});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique1, unique2, existsRel, existsNode}), (Object)Iterators.asSet((Iterator)cache.constraints()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique1}), (Object)Iterators.asSet((Iterator)cache.constraintsForLabel(1)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique1}), (Object)Iterators.asSet((Iterator)cache.constraintsForSchema(unique1.schema())));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{3}))));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{existsRel}), (Object)Iterators.asSet((Iterator)cache.constraintsForRelationshipType(5)));
    }

    @Test
    public void should_remove_constraints() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)this.uniquenessConstraintRule(0L, 1, 2, 133L));
        cache.addSchemaRule((SchemaRule)this.uniquenessConstraintRule(1L, 3, 4, 133L));
        cache.removeSchemaRule(0L);
        UniquenessConstraintDescriptor dropped = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1});
        UniquenessConstraintDescriptor unique = ConstraintDescriptorFactory.uniqueForLabel((int)3, (int[])new int[]{4});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique}), (Object)Iterators.asSet((Iterator)cache.constraints()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForLabel(1)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForSchema(dropped.schema())));
    }

    @Test
    public void adding_constraints_should_be_idempotent() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)this.uniquenessConstraintRule(0L, 1, 2, 133L));
        cache.addSchemaRule((SchemaRule)this.uniquenessConstraintRule(0L, 1, 2, 133L));
        Assert.assertEquals(Arrays.asList(ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{2})), (Object)Iterators.asList((Iterator)cache.constraints()));
    }

    @Test
    public void shouldResolveIndexDescriptor() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)this.newIndexRule(1L, 1, 2));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(2L, 1, 3));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(3L, 2, 2));
        LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{3});
        SchemaIndexDescriptor descriptor = cache.indexDescriptor((SchemaDescriptor)schema);
        MatcherAssert.assertThat((Object)descriptor.schema(), (Matcher)Matchers.equalTo((Object)schema));
    }

    @Test
    public void shouldReturnNullWhenNoIndexExists() {
        SchemaCache schemaCache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        SchemaIndexDescriptor schemaIndexDescriptor = schemaCache.indexDescriptor((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}));
        Assert.assertNull((Object)schemaIndexDescriptor);
    }

    @Test
    public void shouldListConstraintsForLabel() {
        ConstraintRule rule1 = this.uniquenessConstraintRule(0L, 1, 1, 0L);
        ConstraintRule rule2 = this.uniquenessConstraintRule(1L, 2, 1, 0L);
        ConstraintRule rule3 = this.nodePropertyExistenceConstraintRule(2L, 1, 2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.addSchemaRule((SchemaRule)rule3);
        Set listed = Iterators.asSet((Iterator)cache.constraintsForLabel(1));
        Set expected = Iterators.asSet((Object[])new ConstraintDescriptor[]{rule1.getConstraintDescriptor(), rule3.getConstraintDescriptor()});
        Assert.assertEquals((Object)expected, (Object)listed);
    }

    @Test
    public void shouldListConstraintsForSchema() {
        ConstraintRule rule1 = this.uniquenessConstraintRule(0L, 1, 1, 0L);
        ConstraintRule rule2 = this.uniquenessConstraintRule(1L, 2, 1, 0L);
        ConstraintRule rule3 = this.nodePropertyExistenceConstraintRule(2L, 1, 2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.addSchemaRule((SchemaRule)rule3);
        Set listed = Iterators.asSet((Iterator)cache.constraintsForSchema(rule3.schema()));
        Assert.assertEquals(Collections.singleton(rule3.getConstraintDescriptor()), (Object)listed);
    }

    @Test
    public void shouldListConstraintsForRelationshipType() {
        ConstraintRule rule1 = this.relPropertyExistenceConstraintRule(0L, 1, 1);
        ConstraintRule rule2 = this.relPropertyExistenceConstraintRule(0L, 2, 1);
        ConstraintRule rule3 = this.relPropertyExistenceConstraintRule(0L, 1, 2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.addSchemaRule((SchemaRule)rule3);
        Set listed = Iterators.asSet((Iterator)cache.constraintsForRelationshipType(1));
        Set expected = Iterators.asSet((Object[])new ConstraintDescriptor[]{rule1.getConstraintDescriptor(), rule3.getConstraintDescriptor()});
        Assert.assertEquals((Object)expected, (Object)listed);
    }

    @Test
    public void concurrentSchemaRuleAdd() throws Throwable {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        Race race = new Race();
        int indexNumber = 10;
        int i = 0;
        while (i < indexNumber) {
            int id = i++;
            race.addContestant(() -> cache.addSchemaRule((SchemaRule)this.newIndexRule(id, id, id)));
        }
        race.go();
        Assert.assertEquals((long)indexNumber, (long)Iterables.count((Iterable)cache.indexRules()));
        for (int labelId = 0; labelId < indexNumber; ++labelId) {
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)cache.indexDescriptorsForLabel(labelId)));
        }
        for (int propertyId = 0; propertyId < indexNumber; ++propertyId) {
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)cache.indexesByProperty(propertyId)));
        }
    }

    @Test
    public void concurrentSchemaRuleRemove() throws Throwable {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        int indexNumber = 20;
        for (int i = 0; i < indexNumber; ++i) {
            cache.addSchemaRule((SchemaRule)this.newIndexRule(i, i, i));
        }
        Race race = new Race();
        int numberOfDeletions = 10;
        int i = 0;
        while (i < numberOfDeletions) {
            int indexId = i++;
            race.addContestant(() -> cache.removeSchemaRule((long)indexId));
        }
        race.go();
        Assert.assertEquals((long)(indexNumber - numberOfDeletions), (long)Iterables.count((Iterable)cache.indexRules()));
        for (int labelId = numberOfDeletions; labelId < indexNumber; ++labelId) {
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)cache.indexDescriptorsForLabel(labelId)));
        }
        for (int propertyId = numberOfDeletions; propertyId < indexNumber; ++propertyId) {
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)cache.indexesByProperty(propertyId)));
        }
    }

    private IndexRule newIndexRule(long id, int label, int propertyKey) {
        return IndexRule.indexRule((long)id, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.forLabel((int)label, (int[])new int[]{propertyKey}), (IndexProvider.Descriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
    }

    private ConstraintRule nodePropertyExistenceConstraintRule(long ruleId, int labelId, int propertyId) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propertyId}));
    }

    private ConstraintRule relPropertyExistenceConstraintRule(long ruleId, int relTypeId, int propertyId) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{propertyId}));
    }

    private ConstraintRule uniquenessConstraintRule(long ruleId, int labelId, int propertyId, long indexId) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyId}), (long)indexId);
    }

    private static SchemaCache newSchemaCache(SchemaRule ... rules) {
        return new SchemaCache((org.neo4j.kernel.impl.constraints.ConstraintSemantics)new ConstraintSemantics(), rules == null || rules.length == 0 ? Collections.emptyList() : Arrays.asList(rules));
    }

    private static class ConstraintSemantics
    extends StandardConstraintSemantics {
        private ConstraintSemantics() {
        }

        protected ConstraintDescriptor readNonStandardConstraint(ConstraintRule rule, String errorMessage) {
            if (!rule.getConstraintDescriptor().enforcesPropertyExistence()) {
                throw new IllegalStateException("Unsupported constraint type: " + rule);
            }
            return rule.getConstraintDescriptor();
        }
    }
}

