/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.storageengine.api.Direction;

public class RelationshipChangesForNodeTest {
    private static final int REL_0 = 0;
    private static final int REL_1 = 1;
    private static final int TYPE_SELF = 0;
    private static final int TYPE_DIR = 1;

    @Test
    public void testOutgoingRelsWithTypeAndLoop() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, (RelationshipVisitor.Home)Mockito.mock(RelationshipVisitor.Home.class));
        changes.addRelationship(0L, 0, Direction.BOTH);
        changes.addRelationship(1L, 1, Direction.OUTGOING);
        RelationshipIterator iterator = changes.augmentRelationships(Direction.OUTGOING, new int[]{1}, RelationshipIterator.EMPTY);
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertEquals((String)"should have no next relationships but has ", (Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testIncomingRelsWithTypeAndLoop() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, (RelationshipVisitor.Home)Mockito.mock(RelationshipVisitor.Home.class));
        changes.addRelationship(0L, 0, Direction.BOTH);
        changes.addRelationship(1L, 1, Direction.INCOMING);
        RelationshipIterator iterator = changes.augmentRelationships(Direction.INCOMING, new int[]{1}, RelationshipIterator.EMPTY);
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertEquals((String)"should have no next relationships but has ", (Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void shouldGetRelationships() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, (RelationshipVisitor.Home)Mockito.mock(RelationshipVisitor.Home.class));
        int TYPE = 2;
        changes.addRelationship(1L, 2, Direction.INCOMING);
        changes.addRelationship(2L, 2, Direction.OUTGOING);
        changes.addRelationship(3L, 2, Direction.OUTGOING);
        changes.addRelationship(4L, 2, Direction.BOTH);
        changes.addRelationship(5L, 2, Direction.BOTH);
        changes.addRelationship(6L, 2, Direction.BOTH);
        PrimitiveLongIterator rawRelationships = changes.getRelationships();
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rawRelationships), this.ids(1L, 2L, 3L, 4L, 5L, 6L));
    }

    @Test
    public void shouldGetRelationshipsByTypeAndDirection() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, (RelationshipVisitor.Home)Mockito.mock(RelationshipVisitor.Home.class));
        int TYPE = 2;
        int DECOY_TYPE = 666;
        changes.addRelationship(1L, 2, Direction.INCOMING);
        changes.addRelationship(2L, 2, Direction.OUTGOING);
        changes.addRelationship(3L, 2, Direction.OUTGOING);
        changes.addRelationship(4L, 2, Direction.BOTH);
        changes.addRelationship(5L, 2, Direction.BOTH);
        changes.addRelationship(6L, 2, Direction.BOTH);
        changes.addRelationship(10L, 666, Direction.INCOMING);
        changes.addRelationship(11L, 666, Direction.OUTGOING);
        changes.addRelationship(12L, 666, Direction.BOTH);
        PrimitiveLongIterator rawIncoming = changes.getRelationships(RelationshipDirection.INCOMING, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rawIncoming), this.ids(1L));
        PrimitiveLongIterator rawOutgoing = changes.getRelationships(RelationshipDirection.OUTGOING, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rawOutgoing), this.ids(2L, 3L));
        PrimitiveLongIterator rawLoops = changes.getRelationships(RelationshipDirection.LOOP, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rawLoops), this.ids(4L, 5L, 6L));
    }

    private Matcher<long[]> ids(long ... ids) {
        return Matchers.equalTo((Object)ids);
    }
}

