/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.NodeUpdatesIterator;

public class NodeUpdatesIteratorTest {
    @Test
    public void iterateOverEmptyNodeIds() {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        PrimitiveLongIterator emptyIterator = PrimitiveLongCollections.emptyIterator();
        NodeUpdatesIterator nodeUpdatesIterator = new NodeUpdatesIterator(storeView, emptyIterator);
        Assert.assertFalse((boolean)nodeUpdatesIterator.hasNext());
    }

    @Test
    public void iterateOverUpdatesWithNext() {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        NodeUpdates nodeUpdates1 = NodeUpdates.forNode((long)1L).build();
        NodeUpdates nodeUpdates2 = NodeUpdates.forNode((long)2L).build();
        Mockito.when((Object)storeView.nodeAsUpdates(1L)).thenReturn((Object)nodeUpdates1);
        Mockito.when((Object)storeView.nodeAsUpdates(2L)).thenReturn((Object)nodeUpdates2);
        PrimitiveLongIterator nodeIdIterator = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L});
        NodeUpdatesIterator nodeUpdatesIterator = new NodeUpdatesIterator(storeView, nodeIdIterator);
        Assert.assertSame((Object)nodeUpdates1, (Object)nodeUpdatesIterator.next());
        Assert.assertSame((Object)nodeUpdates2, (Object)nodeUpdatesIterator.next());
        Assert.assertFalse((boolean)nodeUpdatesIterator.hasNext());
        ((IndexStoreView)Mockito.verify((Object)storeView)).nodeAsUpdates(1L);
        ((IndexStoreView)Mockito.verify((Object)storeView)).nodeAsUpdates(2L);
    }

    @Test
    public void iterateOverUpdatesWithHasNext() {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        NodeUpdates nodeUpdates1 = NodeUpdates.forNode((long)1L).build();
        NodeUpdates nodeUpdates2 = NodeUpdates.forNode((long)2L).build();
        Mockito.when((Object)storeView.nodeAsUpdates(1L)).thenReturn((Object)nodeUpdates1);
        Mockito.when((Object)storeView.nodeAsUpdates(2L)).thenReturn((Object)nodeUpdates2);
        ArrayDeque<NodeUpdates> updates = new ArrayDeque<NodeUpdates>(Arrays.asList(nodeUpdates1, nodeUpdates2));
        PrimitiveLongIterator nodeIdIterator = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L});
        NodeUpdatesIterator nodeUpdatesIterator = new NodeUpdatesIterator(storeView, nodeIdIterator);
        while (nodeUpdatesIterator.hasNext()) {
            NodeUpdates nodeUpdates = nodeUpdatesIterator.next();
            Assert.assertSame(updates.pop(), (Object)nodeUpdates);
        }
        ((IndexStoreView)Mockito.verify((Object)storeView)).nodeAsUpdates(1L);
        ((IndexStoreView)Mockito.verify((Object)storeView)).nodeAsUpdates(2L);
    }
}

