/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class SchemaLoggingIT {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule((LogProvider)this.logProvider);

    @Test
    public void shouldLogUserReadableLabelAndPropertyNames() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        String labelName = "User";
        String property = "name";
        this.createIndex(db, labelName, property);
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.info("Index population started: [%s]", new Object[]{":User(name) [provider: {key=in-memory-index, version=1.0}]"}), match.info("Index creation finished. Index [%s] is %s.", new Object[]{":User(name) [provider: {key=in-memory-index, version=1.0}]", "ONLINE"})});
    }

    private void createIndex(GraphDatabaseAPI db, String labelName, String property) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)labelName)).on(property).create();
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

