/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;

public class SettingsTest {
    @Rule
    public ExpectedException expect = ExpectedException.none();
    private static BiFunction<File, Function<String, String>, File> isFile = (path, settings) -> {
        if (path.exists() && !path.isFile()) {
            throw new IllegalArgumentException(String.format("%s must point to a file, not a directory", path.toString()));
        }
        return path;
    };

    @Test
    public void parsesAbsolutePaths() {
        File absolutePath = new File("some/path").getAbsoluteFile();
        File thePath = (File)Settings.PATH.apply(absolutePath.toString());
        Assert.assertEquals((Object)absolutePath, (Object)thePath);
    }

    @Test
    public void doesntAllowRelativePaths() {
        File relativePath = new File("some/path");
        this.expect.expect(IllegalArgumentException.class);
        Settings.PATH.apply(relativePath.toString());
    }

    @Test
    public void pathSettingsProvideDefaultValues() {
        File theDefault = new File("/some/path").getAbsoluteFile();
        Setting setting = Settings.pathSetting((String)"some.setting", (String)theDefault.getAbsolutePath());
        Assert.assertThat((Object)Config.defaults().get(setting), (Matcher)Matchers.is((Object)theDefault));
    }

    @Test
    public void pathSettingsAreNullIfThereIsNoValueAndNoDefault() {
        Setting setting = Settings.pathSetting((String)"some.setting", (String)Settings.NO_DEFAULT);
        Assert.assertThat((Object)Config.defaults().get(setting), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldHaveAUsefulToStringWhichIsUsedAsTheValidValuesInDocumentation() {
        Assert.assertThat((Object)Settings.pathSetting((String)"", (String)Settings.NO_DEFAULT).toString(), (Matcher)Matchers.containsString((String)"A filesystem path"));
    }

    @Test
    public void testInteger() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        this.expect.expect(InvalidSettingException.class);
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
    }

    @Test
    public void testList() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4");
        Assert.assertThat((Object)((List)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        Setting setting2 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4,");
        Assert.assertThat((Object)((List)setting2.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        Setting setting3 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"");
        Assert.assertThat((Object)((List)setting3.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        Setting setting4 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,    2,3, 4,   5  ");
        Assert.assertThat((Object)((List)setting4.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4, 5]"));
        Setting setting5 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,    2,3, 4,   ");
        Assert.assertThat((Object)((List)setting5.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
    }

    @Test
    public void testStringList() {
        Setting setting1 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"foo,bar,baz");
        Assert.assertEquals(Arrays.asList("foo", "bar", "baz"), (Object)setting1.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        Setting setting2 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"foo,  bar, BAZ   ");
        Assert.assertEquals(Arrays.asList("foo", "bar", "BAZ"), (Object)setting2.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        Setting setting3 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"");
        Assert.assertEquals(Collections.emptyList(), (Object)setting3.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
    }

    @Test
    public void testMin() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER, (String)"3").constraint(Settings.min((Comparable)Integer.valueOf(2))).build();
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        this.expect.expect(InvalidSettingException.class);
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"})));
    }

    @Test
    public void testMax() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER, (String)"3").constraint(Settings.max((Comparable)Integer.valueOf(5))).build();
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        this.expect.expect(InvalidSettingException.class);
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "7"})));
    }

    @Test
    public void testRange() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER, (String)"3").constraint(Settings.range((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))).build();
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
        try {
            setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "6"})));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testMatches() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.STRING, (String)"abc").constraint(Settings.matches((String)"a*b*c*")).build();
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "aaabbbccc"}))), (Matcher)CoreMatchers.equalTo((Object)"aaabbbccc"));
        this.expect.expect(InvalidSettingException.class);
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "cba"})));
    }

    @Test
    public void testDurationWithBrokenDefault() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION, (String)"1s").constraint(Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))).build();
        this.expect.expect(InvalidSettingException.class);
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
    }

    @Test
    public void testDurationWithValueNotWithinConstraint() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s").constraint(Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))).build();
        this.expect.expect(InvalidSettingException.class);
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "2s"})));
    }

    @Test
    public void testDuration() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s").constraint(Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))).build();
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "4s"}))), (Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(4L)));
    }

    @Test
    public void badDurationMissingNumber() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION).build();
        this.expect.expect(InvalidSettingException.class);
        this.expect.expectMessage("Missing numeric value");
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "ms"})));
    }

    @Test
    public void badDurationInvalidUnit() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION).build();
        this.expect.expect(InvalidSettingException.class);
        this.expect.expectMessage("Unrecognized unit 'gigaseconds'");
        setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "2gigaseconds"})));
    }

    @Test
    public void testDefault() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testPaths() {
        File directory = new File("myDirectory");
        Setting config = Settings.buildSetting((String)"config", (Function)Settings.PATH, (String)new File(directory, "config.properties").getAbsolutePath()).constraint(isFile).build();
        Assert.assertThat((Object)((File)config.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).getAbsolutePath(), (Matcher)CoreMatchers.equalTo((Object)new File(directory, "config.properties").getAbsolutePath()));
    }

    @Test
    public void testInheritOneLevel() {
        Setting root = Settings.setting((String)"root", (Function)Settings.INTEGER, (String)"4");
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER).inherits(root).build();
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"}))), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testInheritHierarchy() {
        Setting a = Settings.setting((String)"A", (Function)Settings.STRING, (String)"A");
        Setting b = Settings.buildSetting((String)"B", (Function)Settings.STRING, (String)"B").inherits(a).build();
        Setting c = Settings.buildSetting((String)"C", (Function)Settings.STRING, (String)"C").inherits(b).build();
        Setting d = Settings.buildSetting((String)"D", (Function)Settings.STRING).inherits(b).build();
        Setting e = Settings.buildSetting((String)"E", (Function)Settings.STRING).inherits(d).build();
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"C", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"A", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"A", "Y", "B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat((Object)d.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
        Assert.assertThat((Object)e.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
    }

    @Test
    public void testLogicalLogRotationThreshold() {
        Setting setting = GraphDatabaseSettings.logical_log_rotation_threshold;
        long defaultValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
        long megaValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{setting.name(), "10M"})));
        long gigaValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{setting.name(), "10g"})));
        Assert.assertThat((Object)defaultValue, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((long)0xA00000L, (long)megaValue);
        Assert.assertEquals((long)0x280000000L, (long)gigaValue);
    }

    @Test
    public void testNormalizedRelativeURI() {
        Setting uri = Settings.setting((String)"mySetting", (Function)Settings.NORMALIZED_RELATIVE_URI, (String)"http://localhost:7474///db///data///");
        Assert.assertThat((Object)((URI)uri.apply(always -> null)).toString(), (Matcher)CoreMatchers.equalTo((Object)"/db/data"));
    }

    @Test
    public void onlySingleInheritanceShouldBeAllowed() {
        Setting a = Settings.setting((String)"A", (Function)Settings.STRING, (String)"A");
        Setting b = Settings.setting((String)"B", (Function)Settings.STRING, (String)"B");
        this.expect.expect(AssertionError.class);
        Setting c = Settings.buildSetting((String)"C", (Function)Settings.STRING, (String)"C").inherits(a).inherits(b).build();
    }

    public static <From, To> Function<From, To> map(Map<From, To> map) {
        return map::get;
    }
}

