/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.Settings;

public class GroupConfigTest {
    @Test
    public void shouldProvideNiceSetMechanism() {
        Assert.assertThat((Object)GroupConfigTest.connector((int)0).enabled.name(), (Matcher)CoreMatchers.equalTo((Object)"dbms.connector.0.enabled"));
    }

    static ConnectorExample connector(int key) {
        return new ConnectorExample(Integer.toString(key));
    }

    @Group(value="dbms.connector")
    static class ConnectorExample {
        public final Setting<Boolean> enabled;
        public final Setting<String> name;
        private final GroupSettingSupport group;

        ConnectorExample(String key) {
            this.group = new GroupSettingSupport(ConnectorExample.class, key);
            this.enabled = this.group.scope(Settings.setting((String)"enabled", (Function)Settings.BOOLEAN, (String)"false"));
            this.name = this.group.scope(Settings.setting((String)"name", (Function)Settings.STRING, (String)"Bob Dylan"));
        }
    }
}

