/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class BuiltInSchemaProceduresIT
extends KernelIntegrationTest {
    @Test
    public void testSchemaTableWithNodes() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        long nodeId2 = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().nodeCreate();
        long nodeId4 = transaction.dataWrite().nodeCreate();
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("A");
        int labelId2 = transaction.tokenWrite().labelGetOrCreateForName("B");
        int labelId3 = transaction.tokenWrite().labelGetOrCreateForName("C");
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        transaction.dataWrite().nodeSetProperty(nodeId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId1, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop1, (Value)Values.booleanValue((boolean)true));
        transaction.dataWrite().nodeSetProperty(nodeId4, prop1, (Value)Values.stringArray((String[])new String[]{"Test", "Success"}));
        transaction.dataWrite().nodeAddLabel(nodeId1, labelId1);
        transaction.dataWrite().nodeAddLabel(nodeId1, labelId2);
        transaction.dataWrite().nodeAddLabel(nodeId2, labelId2);
        transaction.dataWrite().nodeAddLabel(nodeId4, labelId3);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("A", "B"), "prop1", Arrays.asList("String"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("A", "B"), "prop2", Arrays.asList("Integer"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("B"), "prop1", Arrays.asList("Boolean"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("C"), "prop1", Arrays.asList("StringArray"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), null, null, true})}));
    }

    @Test
    public void testSchemaTableWithSimilarNodes() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        long nodeId2 = transaction.dataWrite().nodeCreate();
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("A");
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        transaction.dataWrite().nodeSetProperty(nodeId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop1, (Value)Values.stringValue((String)"Test2"));
        transaction.dataWrite().nodeAddLabel(nodeId1, labelId1);
        transaction.dataWrite().nodeAddLabel(nodeId2, labelId1);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("A"), "prop1", Arrays.asList("String"), false})));
    }

    @Test
    public void testSchemaTableWithSimilarNodesHavingDifferentPropertyValueTypes() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        long nodeId2 = transaction.dataWrite().nodeCreate();
        long nodeId3 = transaction.dataWrite().nodeCreate();
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        int prop3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop3");
        transaction.dataWrite().nodeSetProperty(nodeId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId1, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop2, (Value)Values.floatValue((float)1.5f));
        transaction.dataWrite().nodeSetProperty(nodeId1, prop3, (Value)Values.booleanValue((boolean)true));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop3, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId3, prop1, (Value)Values.stringValue((String)"Test"));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), "prop1", Arrays.asList("String"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), "prop2", Arrays.asList("Integer", "Float"), true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), "prop3", Arrays.asList("String", "Boolean"), true})}));
    }

    @Test
    public void testSchemaTableWithSimilarNodesShouldNotDependOnOrderOfCreation() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.dataWrite().nodeCreate();
        long nodeId2 = transaction.dataWrite().nodeCreate();
        long nodeId3 = transaction.dataWrite().nodeCreate();
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        int prop3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop3");
        transaction.dataWrite().nodeSetProperty(nodeId2, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId3, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().nodeSetProperty(nodeId3, prop2, (Value)Values.floatValue((float)1.5f));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop3, (Value)Values.booleanValue((boolean)true));
        transaction.dataWrite().nodeSetProperty(nodeId3, prop3, (Value)Values.stringValue((String)"Test"));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), "prop1", Arrays.asList("String"), true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), "prop2", Arrays.asList("Integer", "Float"), true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), "prop3", Arrays.asList("String", "Boolean"), true})}));
    }

    @Test
    public void testSchemaTableWithRelationships() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        int typeR = transaction.tokenWrite().relationshipTypeGetOrCreateForName("R");
        int typeX = transaction.tokenWrite().relationshipTypeGetOrCreateForName("X");
        int typeZ = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Z");
        long relId1 = transaction.dataWrite().relationshipCreate(nodeId1, typeR, nodeId1);
        long relId2 = transaction.dataWrite().relationshipCreate(nodeId1, typeX, nodeId1);
        transaction.dataWrite().relationshipCreate(nodeId1, typeZ, nodeId1);
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        transaction.dataWrite().relationshipSetProperty(relId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId1, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().relationshipSetProperty(relId2, prop1, (Value)Values.booleanValue((boolean)true));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop1", Arrays.asList("String"), false}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop2", Arrays.asList("Integer"), false}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("X"), "prop1", Arrays.asList("Boolean"), false}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("Z"), null, null, true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), null, null, true})}));
    }

    @Test
    public void testSchemaTableWithSimilarRelationships() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        int typeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName("R");
        long relId1 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        long relId2 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        transaction.dataWrite().relationshipSetProperty(relId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId2, prop1, (Value)Values.stringValue((String)"Test2"));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop1", Arrays.asList("String"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), null, null, true})}));
    }

    @Test
    public void testSchemaWithRelationshipWithoutProperties() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        int typeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName("R");
        long relId1 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        int prop3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop3");
        transaction.dataWrite().relationshipSetProperty(relId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId1, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().relationshipSetProperty(relId1, prop3, (Value)Values.booleanValue((boolean)true));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), null, null, true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop1", Arrays.asList("String"), true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop2", Arrays.asList("Integer"), true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop3", Arrays.asList("Boolean"), true})}));
    }

    @Test
    public void testSchemaTableWithSimilarRelationshipsHavingDifferentPropertyValueTypes() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        int typeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName("R");
        long relId1 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        long relId2 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        long relId3 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        int prop3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop3");
        transaction.dataWrite().relationshipSetProperty(relId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId2, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId1, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().relationshipSetProperty(relId2, prop2, (Value)Values.floatValue((float)1.5f));
        transaction.dataWrite().relationshipSetProperty(relId1, prop3, (Value)Values.booleanValue((boolean)true));
        transaction.dataWrite().relationshipSetProperty(relId2, prop3, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId3, prop1, (Value)Values.stringValue((String)"Test"));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), null, null, true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop1", Arrays.asList("String"), false}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop2", Arrays.asList("Integer", "Float"), true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop3", Arrays.asList("String", "Boolean"), true})}));
    }

    @Test
    public void testSchemaTableWithSimilarRelationshipsShouldNotDependOnOrderOfCreation() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        int typeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName("R");
        transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        long relId2 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        long relId3 = transaction.dataWrite().relationshipCreate(nodeId1, typeId, nodeId1);
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        int prop3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop3");
        transaction.dataWrite().relationshipSetProperty(relId2, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId3, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().relationshipSetProperty(relId2, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().relationshipSetProperty(relId3, prop2, (Value)Values.floatValue((float)1.5f));
        transaction.dataWrite().relationshipSetProperty(relId2, prop3, (Value)Values.booleanValue((boolean)true));
        transaction.dataWrite().relationshipSetProperty(relId3, prop3, (Value)Values.stringValue((String)"Test"));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList(new Object[0]), null, null, true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop1", Arrays.asList("String"), true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop2", Arrays.asList("Integer", "Float"), true}), IsEqual.equalTo((Object)new Object[]{"Relationship", Arrays.asList("R"), "prop3", Arrays.asList("String", "Boolean"), true})}));
    }

    @Test
    public void testSchemaTableWithNullableProperties() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId1 = transaction.dataWrite().nodeCreate();
        long nodeId2 = transaction.dataWrite().nodeCreate();
        long nodeId3 = transaction.dataWrite().nodeCreate();
        long nodeId4 = transaction.dataWrite().nodeCreate();
        long nodeId5 = transaction.dataWrite().nodeCreate();
        int labelA = transaction.tokenWrite().labelGetOrCreateForName("A");
        int labelB = transaction.tokenWrite().labelGetOrCreateForName("B");
        transaction.dataWrite().nodeAddLabel(nodeId1, labelA);
        transaction.dataWrite().nodeAddLabel(nodeId2, labelA);
        transaction.dataWrite().nodeAddLabel(nodeId3, labelA);
        transaction.dataWrite().nodeAddLabel(nodeId4, labelB);
        transaction.dataWrite().nodeAddLabel(nodeId5, labelB);
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        int prop3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop3");
        transaction.dataWrite().nodeSetProperty(nodeId1, prop1, (Value)Values.stringValue((String)"Test"));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop1, (Value)Values.stringValue((String)"Test2"));
        transaction.dataWrite().nodeSetProperty(nodeId3, prop1, (Value)Values.stringValue((String)"Test3"));
        transaction.dataWrite().nodeSetProperty(nodeId1, prop2, (Value)Values.intValue((int)12));
        transaction.dataWrite().nodeSetProperty(nodeId3, prop2, (Value)Values.intValue((int)42));
        transaction.dataWrite().nodeSetProperty(nodeId1, prop3, (Value)Values.booleanValue((boolean)true));
        transaction.dataWrite().nodeSetProperty(nodeId2, prop3, (Value)Values.booleanValue((boolean)false));
        transaction.dataWrite().nodeSetProperty(nodeId4, prop1, (Value)Values.stringValue((String)"Test4"));
        transaction.dataWrite().nodeSetProperty(nodeId4, prop2, (Value)Values.intValue((int)21));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"okapi", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("A"), "prop1", Arrays.asList("String"), false}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("A"), "prop2", Arrays.asList("Integer"), true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("A"), "prop3", Arrays.asList("Boolean"), true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("B"), "prop1", Arrays.asList("String"), true}), IsEqual.equalTo((Object)new Object[]{"Node", Arrays.asList("B"), "prop2", Arrays.asList("Integer"), true})}));
    }

    private void printStream(RawIterator<Object[], ProcedureException> stream) throws Throwable {
        Iterator iterator = Iterators.asList(stream).iterator();
        while (iterator.hasNext()) {
            Object[] row;
            for (Object column : row = (Object[])iterator.next()) {
                System.out.println(column);
            }
            System.out.println();
        }
    }
}

