/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;

public class AwaitIndexProcedureTest {
    private static final int TIMEOUT = 10;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private KernelTransaction transaction;
    private TokenRead tokenRead;
    private SchemaRead schemaRead;
    private IndexProcedures procedure;
    private LabelSchemaDescriptor descriptor;
    private LabelSchemaDescriptor anyDescriptor;
    private CapableIndexReference anyIndex;

    @Before
    public void setup() {
        this.transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        this.tokenRead = (TokenRead)Mockito.mock(TokenRead.class);
        this.schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        this.procedure = new IndexProcedures(this.transaction, null);
        this.descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
        this.anyDescriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        this.anyIndex = DefaultCapableIndexReference.fromDescriptor((SchemaIndexDescriptor)SchemaIndexDescriptorFactory.forSchema((SchemaDescriptor)this.anyDescriptor));
        Mockito.when((Object)this.transaction.tokenRead()).thenReturn((Object)this.tokenRead);
        Mockito.when((Object)this.transaction.schemaRead()).thenReturn((Object)this.schemaRead);
    }

    @Test
    public void shouldThrowAnExceptionIfTheLabelDoesntExist() {
        Mockito.when((Object)this.tokenRead.nodeLabel("NonExistentLabel")).thenReturn((Object)-1);
        try {
            this.procedure.awaitIndex(":NonExistentLabel(prop)", 10L, TIME_UNIT);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.LabelAccessFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfThePropertyKeyDoesntExist() {
        Mockito.when((Object)this.tokenRead.propertyKey("nonExistentProperty")).thenReturn((Object)-1);
        try {
            this.procedure.awaitIndex(":Label(nonExistentProperty)", 10L, TIME_UNIT);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.PropertyKeyAccessFailed));
        }
    }

    @Test
    public void shouldLookUpTheIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)this.descriptor.getLabelId());
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)this.descriptor.getPropertyId());
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)this.anyIndex);
        Mockito.when((Object)this.schemaRead.indexGetState((IndexReference)ArgumentMatchers.any(IndexReference.class))).thenReturn((Object)InternalIndexState.ONLINE);
        this.procedure.awaitIndex(":Person(name)", 10L, TIME_UNIT);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(this.descriptor.getLabelId(), new int[]{this.descriptor.getPropertyId()});
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexHasFailed() throws SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)this.anyIndex);
        Mockito.when((Object)this.schemaRead.indexGetState((IndexReference)ArgumentMatchers.any(IndexReference.class))).thenReturn((Object)InternalIndexState.FAILED);
        try {
            this.procedure.awaitIndex(":Person(name)", 10L, TIME_UNIT);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.IndexCreationFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexDoesNotExist() throws SchemaRuleNotFoundException {
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)CapableIndexReference.NO_INDEX);
        try {
            this.procedure.awaitIndex(":Person(name)", 10L, TIME_UNIT);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.IndexNotFound));
        }
    }

    @Test
    public void shouldBlockUntilTheIndexIsOnline() throws SchemaRuleNotFoundException, IndexNotFoundKernelException, InterruptedException {
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), (int[])ArgumentMatchers.any())).thenReturn((Object)this.anyIndex);
        AtomicReference<InternalIndexState> state = new AtomicReference<InternalIndexState>(InternalIndexState.POPULATING);
        Mockito.when((Object)this.schemaRead.indexGetState((IndexReference)ArgumentMatchers.any(IndexReference.class))).then(invocationOnMock -> (InternalIndexState)state.get());
        AtomicBoolean done = new AtomicBoolean(false);
        new Thread(() -> {
            try {
                this.procedure.awaitIndex(":Person(name)", 10L, TIME_UNIT);
            }
            catch (ProcedureException e) {
                throw new RuntimeException(e);
            }
            done.set(true);
        }).start();
        Assert.assertThat((Object)done.get(), (Matcher)Matchers.is((Object)false));
        state.set(InternalIndexState.ONLINE);
        org.neo4j.test.assertion.Assert.assertEventually("Procedure did not return after index was online", done::get, Matchers.is((Object)true), 10L, TIME_UNIT);
    }

    @Test
    public void shouldTimeoutIfTheIndexTakesTooLongToComeOnline() throws InterruptedException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.tokenRead.nodeLabel(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.tokenRead.propertyKey(ArgumentMatchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), new int[]{ArgumentMatchers.anyInt()})).thenReturn((Object)this.anyIndex);
        Mockito.when((Object)this.schemaRead.indexGetState((IndexReference)ArgumentMatchers.any(IndexReference.class))).thenReturn((Object)InternalIndexState.POPULATING);
        AtomicReference exception = new AtomicReference();
        new Thread(() -> {
            try {
                this.procedure.awaitIndex(":Person(name)", 0L, TIME_UNIT);
            }
            catch (ProcedureException e) {
                exception.set(e);
            }
        }).start();
        org.neo4j.test.assertion.Assert.assertEventually("Procedure did not time out", exception::get, Matchers.not((Matcher)Matchers.nullValue()), 10L, TIME_UNIT);
        Assert.assertThat((Object)((ProcedureException)((Object)exception.get())).status(), (Matcher)Matchers.is((Object)Status.Procedure.ProcedureTimedOut));
    }
}

