/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public abstract class LabelScanStoreTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    protected final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.testDirectory).around((TestRule)this.expectedException).around((TestRule)this.fileSystemRule);
    private static final long[] NO_LABELS = new long[0];
    private LifeSupport life;
    private TrackingMonitor monitor;
    private LabelScanStore store;
    protected File dir;

    @Before
    public void clearDir() {
        this.dir = this.testDirectory.directory();
    }

    @After
    public void shutdown() {
        if (this.life != null) {
            this.life.shutdown();
        }
    }

    protected abstract LabelScanStore createLabelScanStore(FileSystemAbstraction var1, File var2, FullStoreChangeStream var3, boolean var4, boolean var5, LabelScanStore.Monitor var6);

    @Test
    public void failToRetrieveWriterOnReadOnlyScanStore() {
        this.createAndStartReadOnly();
        this.expectedException.expect(UnsupportedOperationException.class);
        this.store.newWriter();
    }

    @Test
    public void forceShouldNotForceWriterOnReadOnlyScanStore() {
        this.createAndStartReadOnly();
        this.store.force(IOLimiter.unlimited());
    }

    @Test
    public void shouldStartIfLabelScanStoreIndexDoesNotExistInReadOnlyMode() throws IOException {
        this.start(false, true);
        Assert.assertTrue((boolean)this.store.isEmpty());
    }

    @Test
    public void snapshotReadOnlyLabelScanStore() throws IOException {
        this.prepareIndex();
        this.createAndStartReadOnly();
        try (ResourceIterator indexFiles = this.store.snapshotStoreFiles();){
            List filesNames = indexFiles.stream().map(File::getName).collect(Collectors.toList());
            Assert.assertThat((String)"Should have at least index segment file.", filesNames, this.hasBareMinimumFileList());
        }
    }

    protected abstract Matcher<Iterable<? super String>> hasBareMinimumFileList();

    @Test
    public void shouldUpdateIndexOnLabelChange() throws Exception {
        int labelId = 1;
        long nodeId = 10L;
        this.start();
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])NO_LABELS, (long[])new long[]{labelId})));
        this.assertNodesForLabel(labelId, nodeId);
    }

    @Test
    public void shouldUpdateIndexOnAddedLabels() throws Exception {
        int labelId1 = 1;
        int labelId2 = 2;
        long nodeId = 10L;
        this.start();
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])NO_LABELS, (long[])new long[]{labelId1})));
        this.assertNodesForLabel(labelId2, new long[0]);
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])NO_LABELS, (long[])new long[]{labelId1, labelId2})));
        this.assertNodesForLabel(labelId1, nodeId);
        this.assertNodesForLabel(labelId2, nodeId);
    }

    @Test
    public void shouldUpdateIndexOnRemovedLabels() throws Exception {
        int labelId1 = 1;
        int labelId2 = 2;
        long nodeId = 10L;
        this.start();
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])NO_LABELS, (long[])new long[]{labelId1, labelId2})));
        this.assertNodesForLabel(labelId1, nodeId);
        this.assertNodesForLabel(labelId2, nodeId);
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])new long[]{labelId1, labelId2}, (long[])new long[]{labelId2})));
        this.assertNodesForLabel(labelId1, new long[0]);
        this.assertNodesForLabel(labelId2, nodeId);
    }

    @Test
    public void shouldDeleteFromIndexWhenDeletedNode() throws Exception {
        int labelId = 1;
        long nodeId = 10L;
        this.start();
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])NO_LABELS, (long[])new long[]{labelId})));
        this.write(Iterators.iterator((Object)NodeLabelUpdate.labelChanges((long)nodeId, (long[])new long[]{labelId}, (long[])NO_LABELS)));
        this.assertNodesForLabel(labelId, new long[0]);
    }

    @Test
    public void shouldScanSingleRange() {
        int labelId1 = 1;
        int labelId2 = 2;
        long nodeId1 = 10L;
        long nodeId2 = 11L;
        this.start(Arrays.asList(NodeLabelUpdate.labelChanges((long)nodeId1, (long[])NO_LABELS, (long[])new long[]{labelId1}), NodeLabelUpdate.labelChanges((long)nodeId2, (long[])NO_LABELS, (long[])new long[]{labelId1, labelId2})));
        AllEntriesLabelScanReader reader = this.store.allNodeLabelRanges();
        NodeLabelRange range = (NodeLabelRange)Iterators.single((Iterator)reader.iterator());
        Assert.assertArrayEquals((long[])new long[]{nodeId1, nodeId2}, (long[])this.reducedNodes(range));
        Assert.assertArrayEquals((long[])new long[]{labelId1}, (long[])this.sorted(range.labels(nodeId1)));
        Assert.assertArrayEquals((long[])new long[]{labelId1, labelId2}, (long[])this.sorted(range.labels(nodeId2)));
    }

    @Test
    public void shouldScanMultipleRanges() {
        int labelId1 = 1;
        int labelId2 = 2;
        long nodeId1 = 10L;
        long nodeId2 = 1280L;
        this.start(Arrays.asList(NodeLabelUpdate.labelChanges((long)nodeId1, (long[])NO_LABELS, (long[])new long[]{labelId1}), NodeLabelUpdate.labelChanges((long)nodeId2, (long[])NO_LABELS, (long[])new long[]{labelId1, labelId2})));
        AllEntriesLabelScanReader reader = this.store.allNodeLabelRanges();
        Iterator iterator = reader.iterator();
        NodeLabelRange range1 = (NodeLabelRange)iterator.next();
        NodeLabelRange range2 = (NodeLabelRange)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertArrayEquals((long[])new long[]{nodeId1}, (long[])this.reducedNodes(range1));
        Assert.assertArrayEquals((long[])new long[]{nodeId2}, (long[])this.reducedNodes(range2));
        Assert.assertArrayEquals((long[])new long[]{labelId1}, (long[])this.sorted(range1.labels(nodeId1)));
        Assert.assertArrayEquals((long[])new long[]{labelId1, labelId2}, (long[])this.sorted(range2.labels(nodeId2)));
    }

    @Test
    public void shouldWorkWithAFullRange() {
        long labelId = 0L;
        ArrayList<NodeLabelUpdate> updates = new ArrayList<NodeLabelUpdate>();
        HashSet<Long> nodes = new HashSet<Long>();
        for (int i = 0; i < 34; ++i) {
            updates.add(NodeLabelUpdate.labelChanges((long)i, (long[])new long[0], (long[])new long[]{labelId}));
            nodes.add(Long.valueOf(i));
        }
        this.start(updates);
        LabelScanReader reader = this.store.newReader();
        Set nodesWithLabel = PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.nodesWithLabel((int)labelId));
        Assert.assertEquals(nodes, (Object)nodesWithLabel);
    }

    @Test
    public void shouldUpdateAFullRange() throws Exception {
        long label0Id = 0L;
        ArrayList<NodeLabelUpdate> label0Updates = new ArrayList<NodeLabelUpdate>();
        HashSet<Long> nodes = new HashSet<Long>();
        for (int i = 0; i < 34; ++i) {
            label0Updates.add(NodeLabelUpdate.labelChanges((long)i, (long[])new long[0], (long[])new long[]{label0Id}));
            nodes.add(Long.valueOf(i));
        }
        this.start(label0Updates);
        this.write(Collections.emptyIterator());
        LabelScanReader reader = this.store.newReader();
        Set nodesWithLabel0 = PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.nodesWithLabel((int)label0Id));
        Assert.assertEquals(nodes, (Object)nodesWithLabel0);
    }

    @Test
    public void shouldSeeEntriesWhenOnlyLowestIsPresent() {
        long labelId = 0L;
        ArrayList<NodeLabelUpdate> labelUpdates = new ArrayList<NodeLabelUpdate>();
        labelUpdates.add(NodeLabelUpdate.labelChanges((long)0L, (long[])new long[0], (long[])new long[]{labelId}));
        this.start(labelUpdates);
        MutableInt count = new MutableInt();
        AllEntriesLabelScanReader nodeLabelRanges = this.store.allNodeLabelRanges();
        nodeLabelRanges.forEach(nlr -> {
            for (long nodeId : nlr.nodes()) {
                count.add(nlr.labels(nodeId).length);
            }
        });
        Assert.assertThat((Object)count.intValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void write(Iterator<NodeLabelUpdate> iterator) throws IOException {
        try (LabelScanWriter writer = this.store.newWriter();){
            while (iterator.hasNext()) {
                writer.write(iterator.next());
            }
        }
    }

    private long[] sorted(long[] input) {
        Arrays.sort(input);
        return input;
    }

    private long[] reducedNodes(NodeLabelRange range) {
        long[] nodes = range.nodes();
        long[] result = new long[nodes.length];
        int cursor = 0;
        for (long node : nodes) {
            if (range.labels(node).length <= 0) continue;
            result[cursor++] = node;
        }
        return Arrays.copyOf(result, cursor);
    }

    @Test
    public void shouldRebuildFromScratchIfIndexMissing() {
        this.start(Arrays.asList(NodeLabelUpdate.labelChanges((long)1L, (long[])NO_LABELS, (long[])new long[]{1L}), NodeLabelUpdate.labelChanges((long)2L, (long[])NO_LABELS, (long[])new long[]{1L, 2L})));
        Assert.assertTrue((String)"Didn't rebuild the store on startup", (boolean)(this.monitor.noIndexCalled & this.monitor.rebuildingCalled & this.monitor.rebuiltCalled));
        this.assertNodesForLabel(1, 1L, 2L);
        this.assertNodesForLabel(2, 2L);
    }

    @Test
    public void rebuildCorruptedIndexIndexOnStartup() throws Exception {
        List<NodeLabelUpdate> data = Arrays.asList(NodeLabelUpdate.labelChanges((long)1L, (long[])NO_LABELS, (long[])new long[]{1L}), NodeLabelUpdate.labelChanges((long)2L, (long[])NO_LABELS, (long[])new long[]{1L, 2L}));
        this.start(data, true, false);
        this.scrambleIndexFilesAndRestart(data, true, false);
        Assert.assertTrue((String)"Index corruption should be detected", (boolean)this.monitor.corruptedIndex);
        Assert.assertTrue((String)"Index should be rebuild", (boolean)this.monitor.rebuildingCalled);
    }

    @Test
    public void shouldFindDecentAmountOfNodesForALabel() throws Exception {
        boolean labelId = true;
        final int nodeCount = 522;
        this.start();
        this.write((Iterator<NodeLabelUpdate>)new PrefetchingIterator<NodeLabelUpdate>(){
            private int i = -1;

            protected NodeLabelUpdate fetchNextOrNull() {
                return ++this.i < nodeCount ? NodeLabelUpdate.labelChanges((long)this.i, (long[])NO_LABELS, (long[])new long[]{1L}) : null;
            }
        });
        TreeSet<Long> nodeSet = new TreeSet<Long>();
        LabelScanReader reader = this.store.newReader();
        PrimitiveLongResourceIterator nodes = reader.nodesWithLabel(1);
        while (nodes.hasNext()) {
            nodeSet.add(nodes.next());
        }
        reader.close();
        Assert.assertEquals((String)("Found gaps in node id range: " + this.gaps(nodeSet, nodeCount)), (long)nodeCount, (long)nodeSet.size());
    }

    @Test
    public void shouldFindNodesWithAnyOfGivenLabels() throws Exception {
        int labelId1 = 3;
        int labelId2 = 5;
        int labelId3 = 13;
        this.start();
        this.write(Iterators.iterator((Object[])new NodeLabelUpdate[]{NodeLabelUpdate.labelChanges((long)2L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId2}), NodeLabelUpdate.labelChanges((long)1L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1}), NodeLabelUpdate.labelChanges((long)4L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId3}), NodeLabelUpdate.labelChanges((long)5L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId2, labelId3}), NodeLabelUpdate.labelChanges((long)3L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1}), NodeLabelUpdate.labelChanges((long)7L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId2}), NodeLabelUpdate.labelChanges((long)8L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId3}), NodeLabelUpdate.labelChanges((long)6L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId2}), NodeLabelUpdate.labelChanges((long)9L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId3})}));
        try (LabelScanReader reader = this.store.newReader();){
            Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithAnyOfLabels(new int[]{labelId1, labelId2})));
            Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L, 5L, 8L, 9L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithAnyOfLabels(new int[]{labelId1, labelId3})));
            Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithAnyOfLabels(new int[]{labelId1, labelId2, labelId3})));
        }
    }

    @Test
    public void shouldFindNodesWithAllGivenLabels() throws Exception {
        int labelId1 = 3;
        int labelId2 = 5;
        int labelId3 = 13;
        this.start();
        this.write(Iterators.iterator((Object[])new NodeLabelUpdate[]{NodeLabelUpdate.labelChanges((long)5L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId2, labelId3}), NodeLabelUpdate.labelChanges((long)8L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId3}), NodeLabelUpdate.labelChanges((long)3L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1}), NodeLabelUpdate.labelChanges((long)6L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId2}), NodeLabelUpdate.labelChanges((long)1L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1}), NodeLabelUpdate.labelChanges((long)7L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId2}), NodeLabelUpdate.labelChanges((long)4L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId3}), NodeLabelUpdate.labelChanges((long)2L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId2}), NodeLabelUpdate.labelChanges((long)9L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId3})}));
        try (LabelScanReader reader = this.store.newReader();){
            Assert.assertArrayEquals((long[])new long[]{2L, 5L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithAllLabels(new int[]{labelId1, labelId2})));
            Assert.assertArrayEquals((long[])new long[]{4L, 5L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithAllLabels(new int[]{labelId1, labelId3})));
            Assert.assertArrayEquals((long[])new long[]{5L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)reader.nodesWithAllLabels(new int[]{labelId1, labelId2, labelId3})));
        }
    }

    private void prepareIndex() throws IOException {
        this.start();
        try (LabelScanWriter labelScanWriter = this.store.newWriter();){
            labelScanWriter.write(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[0], (long[])new long[]{1L}));
        }
        this.store.shutdown();
    }

    private Set<Long> gaps(Set<Long> ids, int expectedCount) {
        HashSet<Long> gaps = new HashSet<Long>();
        for (long i = 0L; i < (long)expectedCount; ++i) {
            if (ids.contains(i)) continue;
            gaps.add(i);
        }
        return gaps;
    }

    private void assertNodesForLabel(int labelId, long ... expectedNodeIds) {
        HashSet<Long> nodeSet = new HashSet<Long>();
        PrimitiveLongResourceIterator nodes = this.store.newReader().nodesWithLabel(labelId);
        while (nodes.hasNext()) {
            nodeSet.add(nodes.next());
        }
        for (long expectedNodeId : expectedNodeIds) {
            Assert.assertTrue((String)("Expected node " + expectedNodeId + " not found in scan store"), (boolean)nodeSet.remove(expectedNodeId));
        }
        Assert.assertTrue((String)("Unexpected nodes in scan store " + nodeSet), (boolean)nodeSet.isEmpty());
    }

    private void createAndStartReadOnly() {
        this.start();
        this.life.shutdown();
        this.start(false, true);
    }

    private void start() {
        this.start(false, false);
    }

    private void start(boolean usePersistentStore, boolean readOnly) {
        this.start(Collections.emptyList(), usePersistentStore, readOnly);
    }

    private void start(List<NodeLabelUpdate> existingData) {
        this.start(existingData, false, false);
    }

    private void start(List<NodeLabelUpdate> existingData, boolean usePersistentStore, boolean readOnly) {
        this.life = new LifeSupport();
        this.monitor = new TrackingMonitor();
        this.store = this.createLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.asStream(existingData), usePersistentStore, readOnly, (LabelScanStore.Monitor)this.monitor);
        this.life.add((Lifecycle)this.store);
        this.life.start();
        Assert.assertTrue((boolean)this.monitor.initCalled);
    }

    private void scrambleIndexFilesAndRestart(List<NodeLabelUpdate> data, boolean usePersistentStore, boolean readOnly) throws IOException {
        this.shutdown();
        this.corruptIndex(this.fileSystemRule.get(), this.dir);
        this.start(data, usePersistentStore, readOnly);
    }

    protected abstract void corruptIndex(FileSystemAbstraction var1, File var2) throws IOException;

    protected void scrambleFile(File file) throws IOException {
        LabelScanStoreTest.scrambleFile(this.random.random(), file);
    }

    public static void scrambleFile(Random random, File file) throws IOException {
        try (RandomAccessFile fileAccess = new RandomAccessFile(file, "rw");
             FileChannel channel = fileAccess.getChannel();){
            byte[] bytes = new byte[(int)channel.size()];
            LabelScanStoreTest.putRandomBytes(random, bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            channel.position(0L);
            channel.write(buffer);
        }
    }

    private static void putRandomBytes(Random random, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)random.nextInt();
        }
    }

    public static class TrackingMonitor
    extends LabelScanStore.Monitor.Adaptor {
        boolean initCalled;
        public boolean rebuildingCalled;
        public boolean rebuiltCalled;
        public boolean noIndexCalled;
        public boolean corruptedIndex;

        public void noIndex() {
            this.noIndexCalled = true;
        }

        public void notValidIndex() {
            this.corruptedIndex = true;
        }

        public void rebuilding() {
            this.rebuildingCalled = true;
        }

        public void rebuilt(long roughNodeCount) {
            this.rebuiltCalled = true;
        }

        public void init() {
            this.initCalled = true;
        }

        public void reset() {
            this.initCalled = false;
            this.rebuildingCalled = false;
            this.rebuiltCalled = false;
            this.noIndexCalled = false;
            this.corruptedIndex = false;
        }
    }
}

