/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.helpers.HostnamePort;

public class HostnamePortTest {
    @Test
    public void testHostnameOnly() {
        HostnamePort hostnamePort = new HostnamePort("myhost");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    public void testHostnamePort() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1234");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1234}));
    }

    @Test
    public void testHostnamePortRange() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1234-1243");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1243}));
    }

    @Test
    public void testHostnamePortRangeInversed() {
        HostnamePort hostnamePort = new HostnamePort("myhost:1243-1234");
        Assert.assertThat((Object)hostnamePort.getHost(), (Matcher)CoreMatchers.equalTo((Object)"myhost"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1243));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1243, 1234}));
    }

    @Test
    public void testSinglePortOnly() {
        HostnamePort hostnamePort = new HostnamePort(":1234");
        Assert.assertNull((Object)hostnamePort.getHost());
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1234));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1234, 1234}));
    }

    @Test
    public void testPortRangeOnly() {
        HostnamePort hostnamePort = new HostnamePort(":1230-1240");
        Assert.assertNull((Object)hostnamePort.getHost());
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)1230));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{1230, 1240}));
    }

    @Test
    public void testDefaultHost() {
        HostnamePort hostnamePort = new HostnamePort(":1234");
        Assert.assertThat((Object)hostnamePort.getHost("1.2.3.4"), (Matcher)CoreMatchers.equalTo((Object)"1.2.3.4"));
    }

    @Test
    public void testGetHostAddress() throws Exception {
        String hostName = InetAddress.getLocalHost().getHostName();
        Assert.assertThat((Object)HostnamePort.getHostAddress(null, (String)"default"), (Matcher)CoreMatchers.equalTo((Object)"default"));
        Assert.assertThat((Object)HostnamePort.getHostAddress((String)hostName, (String)"default"), (Matcher)CoreMatchers.equalTo((Object)hostName));
    }

    @Test
    public void testGetHostAddressUnknown() {
        String unknownHost = "unknownHost";
        boolean unknownHostUnknown = false;
        try {
            InetAddress.getByName(unknownHost);
        }
        catch (UnknownHostException e) {
            unknownHostUnknown = true;
        }
        Assume.assumeTrue((boolean)unknownHostUnknown);
        Assert.assertThat((Object)HostnamePort.getHostAddress((String)unknownHost, (String)"default"), (Matcher)CoreMatchers.equalTo((Object)unknownHost));
    }

    @Test
    public void testMatchesUnknownHosts() throws Exception {
        String knownHost = InetAddress.getLocalHost().getHostName();
        String unknownHost1 = "unknownHost1";
        String unknownHost2 = "unknownHost2";
        boolean unknownHost1Unknown = false;
        try {
            InetAddress.getByName(unknownHost1);
        }
        catch (UnknownHostException e) {
            unknownHost1Unknown = true;
        }
        boolean unknownHost2Unknown = false;
        try {
            InetAddress.getByName(unknownHost2);
        }
        catch (UnknownHostException e) {
            unknownHost2Unknown = true;
        }
        Assume.assumeTrue((unknownHost1Unknown && unknownHost2Unknown ? 1 : 0) != 0);
        HostnamePort hostnamePortSinglePort = new HostnamePort(unknownHost1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(unknownHost1 + ":1234-1236");
        Assert.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost1 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost1 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost1 + "")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost2 + "")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4:1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + knownHost + ":1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1235")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1236")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1233")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1 + ":1237")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost1)));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost2)));
    }

    @Test
    public void testMatchesKnownHostWithIP() throws Exception {
        String[] host1Parts;
        String hostname1 = InetAddress.getLocalHost().getHostName().replace('.', '-');
        String host1 = InetAddress.getLocalHost().getHostAddress();
        StringBuilder host2 = new StringBuilder();
        for (String part : host1Parts = host1.split("\\.")) {
            int partnum = Integer.parseInt(part);
            host2.append(++partnum % 256 + ".");
        }
        host2.deleteCharAt(host2.length() - 1);
        HostnamePort hostnamePortSinglePort = new HostnamePort(hostname1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(hostname1 + ":1234-1236");
        Assert.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname1 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname1 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1)));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2)));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1235")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1236")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1233")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1 + ":1237")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname1)));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2)));
    }

    @Test
    public void testMatchesIPWithHost() throws Exception {
        String hostname1 = InetAddress.getLocalHost().getHostName();
        String host1 = InetAddress.getLocalHost().getHostAddress();
        String hostname2 = "neo4j.org";
        boolean host2Known = true;
        try {
            InetAddress.getByName(hostname2);
        }
        catch (UnknownHostException e) {
            host2Known = false;
        }
        Assume.assumeTrue((boolean)host2Known);
        Assume.assumeFalse((boolean)hostname1.equals(hostname2));
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assert.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1)));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + hostname2)));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1235")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1236")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1233")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1237")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1)));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + hostname2)));
    }

    @Test
    public void testMatchesIPWithHostUnknown() throws Exception {
        String unknownHost = "unknownHost";
        boolean unknownHostUnknown = false;
        try {
            InetAddress.getByName(unknownHost);
        }
        catch (UnknownHostException e) {
            unknownHostUnknown = true;
        }
        Assume.assumeTrue((boolean)unknownHostUnknown);
        String host1 = InetAddress.getLocalHost().getHostAddress();
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1236")));
    }

    @Test
    public void testMatchesKnownHostWithHost() throws Exception {
        String host1 = InetAddress.getLocalHost().getHostName().replace('.', '-');
        String host2 = "neo4j.org";
        boolean host2Known = true;
        try {
            InetAddress.getByName(host2);
        }
        catch (UnknownHostException e) {
            host2Known = false;
        }
        Assume.assumeTrue((boolean)host2Known);
        Assume.assumeFalse((boolean)host1.equals(host2));
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assert.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1)));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host2)));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1235")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1236")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2 + ":1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1233")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1 + ":1237")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host1)));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + host2)));
    }

    @Test
    public void testMatchesKnownHostWithHostUnknown() throws Exception {
        String host1 = InetAddress.getLocalHost().getHostName();
        String unknownHost = "unknownHost";
        boolean unknownHostUnknown = false;
        try {
            InetAddress.getByName(unknownHost);
        }
        catch (UnknownHostException e) {
            unknownHostUnknown = true;
        }
        Assume.assumeTrue((boolean)unknownHostUnknown);
        HostnamePort hostnamePortSinglePort = new HostnamePort(host1 + ":1234");
        HostnamePort hostnamePortWithRange = new HostnamePort(host1 + ":1234-1236");
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://" + unknownHost + ":1236")));
    }

    @Test
    public void testMatchesIP() {
        HostnamePort hostnamePortSinglePort = new HostnamePort("1.2.3.4:1234");
        HostnamePort hostnamePortWithRange = new HostnamePort("1.2.3.4:1234-1236");
        Assert.assertTrue((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4:1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4:1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://5.6.7.8:1234")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://5.6.7.8:1235")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://1.2.3.4")));
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://5.6.7.8")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1234")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1235")));
        Assert.assertTrue((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1236")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://5.6.7.8:1234")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://5.6.7.8:1235")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1233")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4:1237")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://1.2.3.4")));
        Assert.assertFalse((boolean)hostnamePortWithRange.matches(URI.create("ha://5.6.7.8")));
    }

    @Test
    public void testMatchesNullHostWithUnknownHost() {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        String unknownHost = "unknownHost";
        boolean unknownHostUnknown = false;
        try {
            InetAddress.getByName(unknownHost);
        }
        catch (UnknownHostException e) {
            unknownHostUnknown = true;
        }
        Assume.assumeTrue((boolean)unknownHostUnknown);
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + unknownHost + ":1234")));
    }

    @Test
    public void testMatchesNullHostWithIP() throws Exception {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        String host1IP = InetAddress.getLocalHost().getHostAddress();
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1IP + ":1234")));
    }

    @Test
    public void testMatchesNullHostWithKnownHost() throws Exception {
        HostnamePort hostnamePortSinglePort = new HostnamePort(":1234");
        String host1 = InetAddress.getLocalHost().getHostName();
        Assert.assertFalse((boolean)hostnamePortSinglePort.matches(URI.create("ha://" + host1 + ":1234")));
    }

    @Test
    public void testIPv6Address() {
        HostnamePort hostnamePort = new HostnamePort("[2001:cdba:0:0:0:0:3257:9652]");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[2001:cdba:0:0:0:0:3257:9652]"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    public void testIPv6AddressWithSchemeAndPort() {
        HostnamePort hostnamePort = new HostnamePort("foo://[ff02::1:1]:9191");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[ff02::1:1]"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)9191));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{9191, 9191}));
    }

    @Test
    public void testIPv6Localhost() {
        HostnamePort hostnamePort = new HostnamePort("[::1]");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[::1]"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 0}));
    }

    @Test
    public void testIPv6LocalhostWithSchemeAndPort() {
        HostnamePort hostnamePort = new HostnamePort("foo://[::1]:6362");
        Assert.assertThat((Object)hostnamePort.getHost(null), (Matcher)CoreMatchers.equalTo((Object)"[::1]"));
        Assert.assertThat((Object)hostnamePort.getPort(), (Matcher)CoreMatchers.equalTo((Object)6362));
        Assert.assertThat((Object)hostnamePort.getPorts(), (Matcher)CoreMatchers.equalTo((Object)new int[]{6362, 6362}));
    }
}

