/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Format;

public class FormatTest {
    @Test
    public void shouldDisplayBytes() {
        String format = Format.bytes((long)123L);
        Assert.assertTrue((boolean)format.contains(String.valueOf(123)));
        Assert.assertTrue((boolean)format.endsWith(" B"));
    }

    @Test
    public void shouldDisplayKiloBytes() {
        String format = Format.bytes((long)1234L);
        Assert.assertTrue((boolean)format.startsWith("1"));
        Assert.assertTrue((boolean)format.endsWith(" kB"));
    }

    @Test
    public void shouldDisplayMegaBytes() {
        String format = Format.bytes((long)1234567L);
        Assert.assertTrue((boolean)format.startsWith("1"));
        Assert.assertTrue((boolean)format.endsWith(" MB"));
    }

    @Test
    public void shouldDisplayGigaBytes() {
        String format = Format.bytes((long)1234567890L);
        Assert.assertTrue((boolean)format.startsWith("1"));
        Assert.assertTrue((boolean)format.endsWith(" GB"));
    }

    @Test
    public void shouldDisplayPlainCount() {
        String format = Format.count((long)10L);
        Assert.assertTrue((boolean)format.startsWith("10"));
    }

    @Test
    public void shouldDisplayThousandCount() {
        String format = Format.count((long)2000L);
        Assert.assertTrue((boolean)format.startsWith("2"));
        Assert.assertTrue((boolean)format.endsWith("k"));
    }

    @Test
    public void shouldDisplayMillionCount() {
        String format = Format.count((long)2000000L);
        Assert.assertTrue((boolean)format.startsWith("2"));
        Assert.assertTrue((boolean)format.endsWith("M"));
    }

    @Test
    public void shouldDisplayBillionCount() {
        String format = Format.count((long)2000000000L);
        Assert.assertTrue((boolean)format.startsWith("2"));
        Assert.assertTrue((boolean)format.endsWith("G"));
    }

    @Test
    public void shouldDisplayTrillionCount() {
        String format = Format.count((long)4000000000000L);
        Assert.assertTrue((boolean)format.startsWith("4"));
        Assert.assertTrue((boolean)format.endsWith("T"));
    }

    @Test
    public void displayDuration() {
        Assert.assertThat((Object)Format.duration((long)(TimeUnit.MINUTES.toMillis(1L) + TimeUnit.SECONDS.toMillis(2L))), (Matcher)Matchers.is((Object)"1m 2s"));
        Assert.assertThat((Object)Format.duration((long)42L), (Matcher)Matchers.is((Object)"42ms"));
        Assert.assertThat((Object)Format.duration((long)0L), (Matcher)Matchers.is((Object)"0ms"));
    }
}

