/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexTextValueLengthValidator
implements Validator<Value> {
    private final int maxByteLength;
    private final int checkThreshold;

    public IndexTextValueLengthValidator(int maxByteLength) {
        this.maxByteLength = maxByteLength;
        this.checkThreshold = maxByteLength / 5;
    }

    @Override
    public void validate(Value value) {
        if (value == null || value == Values.NO_VALUE) {
            throw new IllegalArgumentException("Null value");
        }
        if (Values.isTextValue((Object)value) && ((TextValue)value).length() >= this.checkThreshold) {
            this.validate(((TextValue)value).stringValue().getBytes());
        }
    }

    @Override
    public void validate(byte[] encodedValue) {
        if (encodedValue == null) {
            throw new IllegalArgumentException("Null value");
        }
        int byteLength = encodedValue.length;
        if (byteLength > this.maxByteLength) {
            throw new IllegalArgumentException("Property value bytes length: " + byteLength + " is longer than " + this.maxByteLength + ", which is maximum supported length of indexed property value.");
        }
    }
}

