/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public interface RecordProcessor<T extends AbstractBaseRecord>
extends AutoCloseable {
    public boolean process(T var1);

    public void done();

    @Override
    public void close();

    public static class Multiple<T extends AbstractBaseRecord>
    implements RecordProcessor<T> {
        private final RecordProcessor<T>[] processors;

        @SafeVarargs
        public Multiple(RecordProcessor<T> ... processors) {
            this.processors = processors;
        }

        @Override
        public boolean process(T item) {
            boolean result = false;
            for (RecordProcessor<T> processor : this.processors) {
                result |= processor.process(item);
            }
            return result;
        }

        @Override
        public void done() {
            for (RecordProcessor<T> processor : this.processors) {
                processor.done();
            }
        }

        @Override
        public void close() {
            try {
                IOUtils.closeAll((AutoCloseable[])this.processors);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

