/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactionTimeoutMonitor
implements Runnable {
    private final KernelTransactions kernelTransactions;
    private final SystemNanoClock clock;
    private final Log log;

    public KernelTransactionTimeoutMonitor(KernelTransactions kernelTransactions, SystemNanoClock clock, LogService logService) {
        this.kernelTransactions = kernelTransactions;
        this.clock = clock;
        this.log = logService.getInternalLog(KernelTransactionTimeoutMonitor.class);
    }

    @Override
    public synchronized void run() {
        Set<KernelTransactionHandle> activeTransactions = this.kernelTransactions.activeTransactions();
        long nowNanos = this.clock.nanos();
        for (KernelTransactionHandle activeTransaction : activeTransactions) {
            long transactionTimeoutMillis = activeTransaction.timeoutMillis();
            if (transactionTimeoutMillis <= 0L || !this.isTransactionExpired(activeTransaction, nowNanos, transactionTimeoutMillis) || !activeTransaction.markForTermination((Status)Status.Transaction.TransactionTimedOut)) continue;
            this.log.warn("Transaction %s timeout.", new Object[]{activeTransaction});
        }
    }

    private boolean isTransactionExpired(KernelTransactionHandle activeTransaction, long nowNanos, long transactionTimeoutMillis) {
        return nowNanos - activeTransaction.startTimeNanos() > TimeUnit.MILLISECONDS.toNanos(transactionTimeoutMillis);
    }
}

