/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;

public abstract class SchemaRule
implements SchemaDescriptorSupplier {
    protected final long id;
    protected final String name;

    protected SchemaRule(long id) {
        this(id, null);
    }

    protected SchemaRule(long id, String name) {
        this.id = id;
        this.name = name == null ? SchemaRule.generateName(id, this.getClass()) : this.checkName(name);
    }

    private String checkName(String name) {
        int length = name.length();
        if (length == 0) {
            throw new IllegalArgumentException("Schema rule name cannot be the empty string");
        }
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch != '\u0000') continue;
            throw new IllegalArgumentException("Illegal schema rule name: '" + name + "'");
        }
        return name;
    }

    public final long getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public abstract byte[] serialize();

    public static String generateName(long id, Class<? extends SchemaRule> type) {
        if (type == IndexRule.class) {
            return "index_" + id;
        }
        if (type == ConstraintRule.class) {
            return "constraint_" + id;
        }
        return "schema_" + id;
    }

    @Deprecated
    public static enum Kind {
        INDEX_RULE("Index"),
        CONSTRAINT_INDEX_RULE("Constraint index"),
        UNIQUENESS_CONSTRAINT("Uniqueness constraint"),
        NODE_PROPERTY_EXISTENCE_CONSTRAINT("Node property existence constraint"),
        RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT("Relationship property existence constraint");

        private static final Kind[] ALL;
        private final String userString;
        private static SchemaComputer<Kind> existenceKindMapper;

        private Kind(String userString) {
            this.userString = userString;
        }

        public byte id() {
            return (byte)(this.ordinal() + 1);
        }

        public String userString() {
            return this.userString;
        }

        public static Kind forId(byte id) throws MalformedSchemaRuleException {
            if (id >= 1 && id <= ALL.length) {
                return Kind.values()[id - 1];
            }
            throw new MalformedSchemaRuleException(null, "Unknown kind id %d", id);
        }

        public static Kind map(SchemaIndexDescriptor descriptor) {
            switch (descriptor.type()) {
                case GENERAL: {
                    return INDEX_RULE;
                }
                case UNIQUE: {
                    return CONSTRAINT_INDEX_RULE;
                }
            }
            throw new IllegalStateException("Cannot map descriptor type to legacy schema rule: " + (Object)((Object)descriptor.type()));
        }

        public static Kind map(ConstraintDescriptor descriptor) {
            switch (descriptor.type()) {
                case UNIQUE: {
                    return UNIQUENESS_CONSTRAINT;
                }
                case EXISTS: {
                    return (Kind)((Object)descriptor.schema().computeWith(existenceKindMapper));
                }
            }
            throw new IllegalStateException("Cannot map descriptor type to legacy schema rule: " + descriptor.type());
        }

        static {
            ALL = Kind.values();
            existenceKindMapper = new SchemaComputer<Kind>(){

                public Kind computeSpecific(LabelSchemaDescriptor schema) {
                    return NODE_PROPERTY_EXISTENCE_CONSTRAINT;
                }

                public Kind computeSpecific(RelationTypeSchemaDescriptor schema) {
                    return RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT;
                }
            };
        }
    }
}

