/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.file.OpenOption;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageStatement;

public class RelationshipStore
extends CommonAbstractStore<RelationshipRecord, NoStoreHeader>
implements StorageStatement.Relationships {
    public static final String TYPE_DESCRIPTOR = "RelationshipStore";

    public RelationshipStore(File fileName, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormats recordFormats, OpenOption ... openOptions) {
        super(fileName, configuration, IdType.RELATIONSHIP, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.relationship(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, recordFormats.storeVersion(), openOptions);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipRecord record) throws FAILURE {
        processor.processRelationship(this, record);
    }
}

