/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.unsafe.impl.batchimport.input.InputCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

class CachingInputChunk
implements InputChunk {
    private final InputChunk actual;
    private final InputCacher cacher;
    private InputEntityVisitor wrapped;
    private InputEntityVisitor unwrapped;

    CachingInputChunk(InputChunk actual, InputCacher cacher) {
        this.actual = actual;
        this.cacher = cacher;
    }

    InputChunk actual() {
        return this.actual;
    }

    @Override
    public void close() throws IOException {
        this.actual.close();
    }

    @Override
    public boolean next(InputEntityVisitor unwrapped) throws IOException {
        if (this.wrapped == null) {
            this.unwrapped = unwrapped;
            this.wrapped = this.cacher.wrap(unwrapped);
        } else assert (this.unwrapped == unwrapped);
        return this.actual.next(this.wrapped);
    }
}

