/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class TimeUtil {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final String VALID_TIME_DESCRIPTION = "Valid units are: 'ms', 's', 'm' and 'h'; default unit is 's'";
    public static final Function<String, Long> parseTimeMillis = timeWithOrWithoutUnit -> {
        int unitIndex = -1;
        for (int i = 0; i < timeWithOrWithoutUnit.length(); ++i) {
            char ch = timeWithOrWithoutUnit.charAt(i);
            if (Character.isDigit(ch)) continue;
            unitIndex = i;
            break;
        }
        if (unitIndex == -1) {
            return DEFAULT_TIME_UNIT.toMillis(Integer.parseInt(timeWithOrWithoutUnit));
        }
        String unit = timeWithOrWithoutUnit.substring(unitIndex).toLowerCase();
        if (unitIndex == 0) {
            throw new IllegalArgumentException("Missing numeric value");
        }
        int amount = Integer.parseInt(timeWithOrWithoutUnit.substring(0, unitIndex));
        switch (unit) {
            case "ms": {
                return TimeUnit.MILLISECONDS.toMillis(amount);
            }
            case "s": {
                return TimeUnit.SECONDS.toMillis(amount);
            }
            case "m": {
                return TimeUnit.MINUTES.toMillis(amount);
            }
            case "h": {
                return TimeUnit.HOURS.toMillis(amount);
            }
        }
        throw new IllegalArgumentException("Unrecognized unit '" + unit + "'. " + VALID_TIME_DESCRIPTION);
    };

    public static String nanosToString(long nanos) {
        long microseconds;
        long milliseconds;
        long seconds;
        long minutes;
        long hours;
        assert (nanos >= 0L);
        long nanoSeconds = nanos;
        StringBuilder timeString = new StringBuilder();
        long days = TimeUnit.DAYS.convert(nanoSeconds, TimeUnit.NANOSECONDS);
        if (days > 0L) {
            nanoSeconds -= TimeUnit.DAYS.toNanos(days);
            timeString.append(days).append('d');
        }
        if ((hours = TimeUnit.HOURS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.HOURS.toNanos(hours);
            timeString.append(hours).append('h');
        }
        if ((minutes = TimeUnit.MINUTES.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MINUTES.toNanos(minutes);
            timeString.append(minutes).append('m');
        }
        if ((seconds = TimeUnit.SECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.SECONDS.toNanos(seconds);
            timeString.append(seconds).append('s');
        }
        if ((milliseconds = TimeUnit.MILLISECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MILLISECONDS.toNanos(milliseconds);
            timeString.append(milliseconds).append("ms");
        }
        if ((microseconds = TimeUnit.MICROSECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MICROSECONDS.toNanos(microseconds);
            timeString.append(microseconds).append("\u03bcs");
        }
        if (nanoSeconds > 0L || timeString.length() == 0) {
            timeString.append(nanoSeconds).append("ns");
        }
        return timeString.toString();
    }

    private TimeUtil() {
        throw new AssertionError();
    }
}

