/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacheWriter;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class InputNodeCacheWriter
extends InputEntityCacheWriter {
    public InputNodeCacheWriter(StoreChannel channel, StoreChannel header, RecordFormats recordFormats, int chunkSize) {
        super(channel, header, recordFormats, chunkSize);
    }

    @Override
    protected InputEntityCacheWriter.SerializingInputEntityVisitor instantiateWrapper(InputEntityVisitor visitor, int chunkSize) {
        return new SerializingInputNodeVisitor(visitor, chunkSize);
    }

    class SerializingInputNodeVisitor
    extends InputEntityCacheWriter.SerializingInputEntityVisitor {
        private String[] previousLabels;

        SerializingInputNodeVisitor(InputEntityVisitor actual, int chunkSize) {
            super(actual, chunkSize);
            this.previousLabels = InputEntityCacheWriter.EMPTY_STRING_ARRAY;
        }

        @Override
        protected void serializeEntity() throws IOException {
            this.writeProperties();
            this.writeGroup(this.idGroup, 0);
            this.writeValue(this.id());
            if (this.hasLabelField) {
                this.buffer(9).put((byte)3).putLong(this.labelField);
            } else {
                String[] labels = this.labels();
                this.writeLabelDiff((byte)1, this.previousLabels, labels);
                this.writeLabelDiff((byte)2, labels, this.previousLabels);
                this.buffer(1).put((byte)0);
                this.previousLabels = labels;
            }
        }

        @Override
        protected void clearState() {
            this.previousLabels = InputEntityCacheWriter.EMPTY_STRING_ARRAY;
            super.clearState();
        }

        protected void writeLabelDiff(byte mode, String[] compare, String[] with) throws IOException {
            for (String value : compare) {
                if (ArrayUtil.contains(with, value)) continue;
                this.buffer(1).put(mode);
                this.writeToken((byte)1, value);
            }
        }
    }
}

