/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.storageengine.api.Token;

class BatchTokenHolder {
    private final Map<String, Token> nameToToken = new HashMap<String, Token>();
    private final PrimitiveIntObjectMap<Token> idToToken = Primitive.intObjectMap((int)20);

    BatchTokenHolder(List<? extends Token> tokens) {
        for (Token token : tokens) {
            this.addToken(token);
        }
    }

    void addToken(Token token) {
        this.nameToToken.put(token.name(), token);
        this.idToToken.put(token.id(), (Object)token);
    }

    Token byId(int id) {
        return (Token)this.idToToken.get(id);
    }

    Token byName(String name) {
        return this.nameToToken.get(name);
    }
}

