/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;

abstract class SchemaLayout<KEY extends NativeSchemaKey<KEY>>
extends Layout.Adapter<KEY, NativeSchemaValue> {
    private final long identifier;
    private final int majorVersion;
    private final int minorVersion;

    SchemaLayout(long identifier, int majorVersion, int minorVersion) {
        this.identifier = identifier;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    SchemaLayout(String layoutName, int majorVersion, int minorVersion) {
        this(Layout.namedIdentifier((String)layoutName, (int)0), majorVersion, minorVersion);
    }

    public NativeSchemaValue newValue() {
        return NativeSchemaValue.INSTANCE;
    }

    public int valueSize(NativeSchemaValue nativeSchemaValue) {
        return 0;
    }

    public void writeValue(PageCursor cursor, NativeSchemaValue nativeSchemaValue) {
    }

    public void readValue(PageCursor cursor, NativeSchemaValue into, int valueSize) {
    }

    public boolean fixedSize() {
        return true;
    }

    public long identifier() {
        return this.identifier;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public final int compare(KEY o1, KEY o2) {
        int valueComparison = this.compareValue(o1, o2);
        if (valueComparison == 0 && ((NativeSchemaKey)((Object)o1)).getCompareId() & ((NativeSchemaKey)((Object)o2)).getCompareId()) {
            return Long.compare(((NativeSchemaKey)((Object)o1)).getEntityId(), ((NativeSchemaKey)((Object)o2)).getEntityId());
        }
        return valueComparison;
    }

    int compareValue(KEY o1, KEY o2) {
        return ((NativeSchemaKey)((Object)o1)).compareValueTo(o2);
    }
}

