/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve3D;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;

public abstract class SpaceFillingCurveSettings {
    protected int dimensions;
    int maxLevels;
    Envelope extents;

    static SpaceFillingCurveSettings fromConfig(int dimensions, int maxBits, Envelope extents) {
        return new SettingsFromConfig(dimensions, maxBits, extents);
    }

    public static SpaceFillingCurveSettings fromGBPTree(File indexFile, PageCache pageCache, Function<ByteBuffer, String> onError) throws IOException {
        SettingsFromIndexHeader settings = new SettingsFromIndexHeader();
        GBPTree.readHeader((PageCache)pageCache, (File)indexFile, (Header.Reader)settings.headerReader(onError));
        if (settings.isFailed()) {
            throw new IOException(settings.getFailureMessage());
        }
        return settings;
    }

    public Consumer<PageCursor> headerWriter(byte initialIndexState) {
        return cursor -> {
            cursor.putByte(initialIndexState);
            cursor.putInt(SpatialIndexType.SingleSpaceFillingCurve.id);
            SpatialIndexType.SingleSpaceFillingCurve.writeHeader(this, (PageCursor)cursor);
        };
    }

    private SpaceFillingCurveSettings(int dimensions, Envelope extents, int maxLevels) {
        this.dimensions = dimensions;
        this.extents = extents;
        this.maxLevels = maxLevels;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public Envelope indexExtents() {
        return this.extents;
    }

    public SpaceFillingCurve curve() {
        if (this.dimensions == 2) {
            return new HilbertSpaceFillingCurve2D(this.extents, this.maxLevels);
        }
        if (this.dimensions == 3) {
            return new HilbertSpaceFillingCurve3D(this.extents, this.maxLevels);
        }
        throw new IllegalArgumentException("Cannot create spatial index with other than 2D or 3D coordinate reference system: " + this.dimensions + "D");
    }

    public int hashCode() {
        return 31 * this.extents.hashCode() + this.maxLevels;
    }

    public boolean equals(SpaceFillingCurveSettings other) {
        return this.dimensions == other.dimensions && this.maxLevels == other.maxLevels && this.extents.equals((Object)other.extents);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpaceFillingCurveSettings) {
            return this.equals((SpaceFillingCurveSettings)obj);
        }
        return false;
    }

    public String toString() {
        return String.format("Space filling curves settings: dimensions=%d, maxLevels=%d, min=%s, max=%s", this.dimensions, this.maxLevels, Arrays.toString(this.extents.getMin()), Arrays.toString(this.extents.getMax()));
    }

    private static enum SpatialIndexType {
        SingleSpaceFillingCurve(1){

            @Override
            public void writeHeader(SpaceFillingCurveSettings settings, PageCursor cursor) {
                cursor.putInt(settings.maxLevels);
                cursor.putInt(settings.dimensions);
                double[] min = settings.extents.getMin();
                double[] max = settings.extents.getMax();
                for (int i = 0; i < settings.dimensions; ++i) {
                    cursor.putLong(Double.doubleToLongBits(min[i]));
                    cursor.putLong(Double.doubleToLongBits(max[i]));
                }
            }

            @Override
            public void readHeader(SettingsFromIndexHeader settings, ByteBuffer headerBytes) {
                try {
                    settings.maxLevels = headerBytes.getInt();
                    settings.dimensions = headerBytes.getInt();
                    double[] min = new double[settings.dimensions];
                    double[] max = new double[settings.dimensions];
                    for (int i = 0; i < settings.dimensions; ++i) {
                        min[i] = headerBytes.getDouble();
                        max[i] = headerBytes.getDouble();
                    }
                    settings.extents = new Envelope(min, max);
                }
                catch (BufferUnderflowException e) {
                    settings.markAsFailed("Failed to read settings from GBPTree header: " + e.getMessage());
                }
            }
        };

        private int id;

        public abstract void writeHeader(SpaceFillingCurveSettings var1, PageCursor var2);

        public abstract void readHeader(SettingsFromIndexHeader var1, ByteBuffer var2);

        private SpatialIndexType(int id) {
            this.id = id;
        }

        static SpatialIndexType get(int id) {
            for (SpatialIndexType type : SpatialIndexType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }

    private static class SettingsFromIndexHeader
    extends SpaceFillingCurveSettings {
        private String failureMessage;

        private SettingsFromIndexHeader() {
            super(0, null, 0);
        }

        private void markAsFailed(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        private void markAsSucceeded() {
            this.failureMessage = null;
        }

        private String getFailureMessage() {
            return this.failureMessage;
        }

        private boolean isFailed() {
            return this.failureMessage != null;
        }

        private Header.Reader headerReader(Function<ByteBuffer, String> onError) {
            return headerBytes -> {
                byte state = headerBytes.get();
                if (state == 0) {
                    this.failureMessage = "Unexpectedly trying to read the header of a failed index: " + (String)onError.apply(headerBytes);
                } else {
                    int typeId = headerBytes.getInt();
                    SpatialIndexType indexType = SpatialIndexType.get(typeId);
                    if (indexType == null) {
                        this.markAsFailed("Unknown spatial index type in index header: " + typeId);
                    } else {
                        this.markAsSucceeded();
                        indexType.readHeader(this, headerBytes);
                    }
                }
            };
        }
    }

    private static class SettingsFromConfig
    extends SpaceFillingCurveSettings {
        private SettingsFromConfig(int dimensions, int maxBits, Envelope extents) {
            super(dimensions, extents, SettingsFromConfig.calcMaxLevels(dimensions, maxBits));
        }

        private static int calcMaxLevels(int dimensions, int maxBits) {
            int maxConfigured = maxBits / dimensions;
            int maxSupported = dimensions == 2 ? 30 : 20;
            return Math.min(maxConfigured, maxSupported);
        }
    }
}

